/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generator;

import com.lothrazar.cyclic.ConfigManager;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.generator.ContainerGenerator;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePeatGenerator
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int BURNTIME = 40;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private int burnTime;
    private int flowing = 1;
    private int fuelRate = 0;

    public TilePeatGenerator() {
        super(BlockRegistry.Tiles.peat_generator);
        this.setNeedsRedstone(0);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1);
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(64000, 32000);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.setFlowing(tag.func_74762_e("flowing"));
        this.burnTime = tag.func_74762_e("burnTime");
        this.fuelRate = tag.func_74762_e("fuelRate");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("flowing", this.getFlowing());
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74768_a("fuelRate", this.fuelRate);
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.isBurning() && !this.isFull() && this.fuelRate > 0) {
            --this.burnTime;
            this.addEnergy(this.fuelRate);
            return;
        }
        this.fuelRate = 0;
        IEnergyStorage energyActual = (IEnergyStorage)this.energy.orElse(null);
        if (this.energy.isPresent() && energyActual != null) {
            if (energyActual.getEnergyStored() < 0) {
                // empty if block
            }
            if (!this.field_145850_b.field_72995_K) {
                // empty if block
            }
            this.inventory.ifPresent(h -> {
                int hackyFuel;
                ItemStack stack = h.getStackInSlot(0);
                int n = hackyFuel = stack.func_77973_b() == ItemRegistry.peat_fuel ? (Integer)ConfigManager.PEATPOWER.get() : 0;
                if (stack.func_77973_b() == ItemRegistry.peat_fuel_enriched) {
                    hackyFuel = (Integer)ConfigManager.PEATERICHPOWER.get();
                }
                if (hackyFuel > 0) {
                    this.fuelRate = hackyFuel;
                    h.extractItem(0, 1, false);
                    this.burnTime = 40;
                }
            });
        }
        if (this.getFlowing() == 1) {
            this.tickCableFlow();
        }
    }

    private void tickCableFlow() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction exportToSide = Direction.values()[i];
            this.moveEnergy(exportToSide, 32000);
        }
    }

    public boolean isFull() {
        CustomEnergyStorage e = (CustomEnergyStorage)((Object)this.energy.cast().orElse(null));
        return e == null || e.getEnergyStored() >= e.getMaxEnergyStored();
    }

    private void addEnergy(int i) {
        this.energy.ifPresent(e -> ((CustomEnergyStorage)((Object)e)).addEnergy(i));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int value) {
        this.burnTime = value;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerGenerator(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getFlowing() {
        return this.flowing;
    }

    public void setFlowing(int flowing) {
        this.flowing = flowing;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.renderParticles = value % 2;
            }
        }
    }

    public static enum Fields {
        FLOWING,
        REDSTONE,
        RENDER;

    }
}

