/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.harvester;

import com.lothrazar.cyclic.ConfigManager;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.harvester.ContainerHarvester;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileHarvester
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final BlockTags.Wrapper HARVEST_BREAK = new BlockTags.Wrapper(new ResourceLocation("cyclic", "harvester_break"));
    private static final int RADIUS = 9;
    private static final int ATTEMPTS_PERTICK = 16;
    static final int MAX = 640000;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    BlockPos laserTarget;
    int laserTimer;

    public TileHarvester() {
        super(BlockRegistry.Tiles.harvesterTile);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void func_73660_a() {
        IEnergyStorage cap;
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.laserTimer > 0) {
            --this.laserTimer;
        }
        if ((cap = (IEnergyStorage)this.energy.orElse(null)) == null) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos target = UtilWorld.getRandomPos(this.field_145850_b.field_73012_v, this.func_174877_v(), 9);
            if (cap.getEnergyStored() < (Integer)ConfigManager.HARVESTERPOWER.get()) break;
            if (!this.tryHarvestSingle(target)) continue;
            cap.extractEnergy(((Integer)ConfigManager.HARVESTERPOWER.get()).intValue(), true);
            break;
        }
    }

    private boolean tryHarvestSingle(BlockPos posCurrent) {
        int maxAge;
        BlockState blockState = this.field_145850_b.func_180495_p(posCurrent);
        if (TileHarvester.simpleBreakDrop(blockState)) {
            UtilItemStack.drop(this.field_145850_b, posCurrent, blockState.func_177230_c());
            this.field_145850_b.func_175655_b(posCurrent, false);
            return true;
        }
        IntegerProperty propInt = TileHarvester.getAgeProp(blockState);
        if (propInt == null || !(this.field_145850_b instanceof ServerWorld)) {
            return false;
        }
        int currentAge = (Integer)blockState.func_177229_b((IProperty)propInt);
        int minAge = (Integer)Collections.min(propInt.func_177700_c());
        if (minAge == (maxAge = ((Integer)Collections.max(propInt.func_177700_c())).intValue()) || currentAge < maxAge) {
            return false;
        }
        List drops = Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)posCurrent, (TileEntity)null);
        List seeds = Block.func_220070_a((BlockState)blockState.func_177230_c().func_176223_P(), (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)posCurrent, (TileEntity)null);
        boolean deleteSeed = drops.size() > 0;
        ItemStack seed = ItemStack.field_190927_a;
        if (seeds != null && seeds.size() > 0) {
            seed = (ItemStack)seeds.get(0);
        }
        for (ItemStack drop : drops) {
            if (deleteSeed && drop.func_77973_b() == seed.func_77973_b() && drops.size() > 1) {
                drop.func_190918_g(1);
                deleteSeed = false;
            }
            if (drop.func_190916_E() <= 0) continue;
            UtilWorld.dropItemStackInWorld(this.field_145850_b, posCurrent, drop);
        }
        this.field_145850_b.func_175656_a(posCurrent, (BlockState)blockState.func_206870_a((IProperty)propInt, (Comparable)Integer.valueOf(minAge)));
        this.laserTarget = posCurrent;
        this.laserTimer = 15;
        this.field_145850_b.func_184138_a(posCurrent, this.func_195044_w(), this.func_195044_w(), 3);
        UtilWorld.flagUpdate(this.field_145850_b, this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        this.func_70296_d();
        return true;
    }

    private static boolean simpleBreakDrop(BlockState blockState) {
        boolean breakit = blockState.func_177230_c().func_203417_a((Tag)HARVEST_BREAK);
        return breakit;
    }

    public static IntegerProperty getAgeProp(BlockState blockState) {
        for (IProperty p : blockState.func_206869_a()) {
            if (p == null || p.func_177701_a() == null || !(p instanceof IntegerProperty) || !p.func_177701_a().equalsIgnoreCase("age")) continue;
            return (IntegerProperty)p;
        }
        return null;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
            }
        }
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(640000, 160000);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.laserTarget = UtilNBT.getBlockPos(tag);
        this.laserTimer = tag.func_74762_e("lt");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.laserTarget == null) {
            this.laserTarget = BlockPos.field_177992_a;
        }
        UtilNBT.putBlockPos(tag, this.laserTarget);
        tag.func_74768_a("lt", this.laserTimer);
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerHarvester(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public static enum Fields {
        REDSTONE;

    }
}

