/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapebuilder;

import com.lothrazar.cyclic.base.ScreenBase;
import com.lothrazar.cyclic.block.shapebuilder.BuildStructureType;
import com.lothrazar.cyclic.block.shapebuilder.ContainerStructure;
import com.lothrazar.cyclic.block.shapebuilder.TileStructure;
import com.lothrazar.cyclic.gui.ButtonMachine;
import com.lothrazar.cyclic.gui.EnergyBar;
import com.lothrazar.cyclic.gui.TextboxInteger;
import com.lothrazar.cyclic.gui.TextureEnum;
import com.lothrazar.cyclic.net.PacketTileData;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.TextureRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class ScreenStructure
extends ScreenBase<ContainerStructure> {
    private TextboxInteger txtHeight;
    private TextboxInteger txtSize;
    private EnergyBar energy = new EnergyBar((Screen)this, 64000);
    public ButtonMachine btnRedstone;
    private List<ButtonMachine> shapeBtuns;
    private ButtonMachine btnRender;

    public ScreenStructure(ContainerStructure screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.energy.guiLeft = this.field_147003_i;
        this.energy.guiTop = this.field_147009_r;
        int x = this.field_147003_i + 8;
        int y = this.field_147009_r + 8;
        this.btnRedstone = (ButtonMachine)this.addButton((Widget)new ButtonMachine(x, y, 20, 20, "", p -> {
            ((ContainerStructure)this.field_147002_h).tile.setNeedsRedstone((((ContainerStructure)this.field_147002_h).tile.getNeedsRedstone() + 1) % 2);
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketTileData(TileStructure.Fields.REDSTONE.ordinal(), ((ContainerStructure)this.field_147002_h).tile.getNeedsRedstone(), ((ContainerStructure)this.field_147002_h).tile.func_174877_v()));
        }));
        this.btnRender = (ButtonMachine)this.addButton((Widget)new ButtonMachine(x + 20, y, 20, 20, "", p -> {
            int f = TileStructure.Fields.RENDER.ordinal();
            ((ContainerStructure)this.field_147002_h).tile.setField(f, (((ContainerStructure)this.field_147002_h).tile.getField(f) + 1) % 2);
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketTileData(f, ((ContainerStructure)this.field_147002_h).tile.getField(f), ((ContainerStructure)this.field_147002_h).tile.func_174877_v()));
        }));
        this.txtHeight = new TextboxInteger(this.font, this.field_147003_i + 120, this.field_147009_r + 20, 20, ((ContainerStructure)this.field_147002_h).tile.func_174877_v(), TileStructure.Fields.HEIGHT.ordinal());
        this.txtHeight.func_146180_a("" + ((ContainerStructure)this.field_147002_h).tile.getField(TileStructure.Fields.HEIGHT.ordinal()));
        this.txtHeight.setTooltip(UtilChat.lang("buildertype.height.tooltip"));
        this.children.add(this.txtHeight);
        this.txtSize = new TextboxInteger(this.font, this.field_147003_i + 90, this.field_147009_r + 20, 20, ((ContainerStructure)this.field_147002_h).tile.func_174877_v(), TileStructure.Fields.SIZE.ordinal());
        this.txtSize.setTooltip(UtilChat.lang("buildertype.size.tooltip"));
        this.txtSize.func_146180_a("" + ((ContainerStructure)this.field_147002_h).tile.getField(TileStructure.Fields.SIZE.ordinal()));
        this.children.add(this.txtSize);
        TileStructure.Fields fld = TileStructure.Fields.BUILDTYPE;
        int numInRow = 0;
        x = this.field_147003_i + 4;
        y = this.field_147009_r + 38;
        int bsize = 20;
        this.shapeBtuns = new ArrayList<ButtonMachine>();
        for (BuildStructureType shape : BuildStructureType.values()) {
            if (++numInRow == 7) {
                x = this.field_147003_i + 4;
                y += bsize;
            }
            String shapeName = UtilChat.lang("buildertype." + shape.name().toLowerCase());
            ButtonMachine btnShape = (ButtonMachine)this.addButton((Widget)new ButtonMachine(x, y, bsize, bsize, shapeName.substring(0, 2), p -> PacketRegistry.INSTANCE.sendToServer((Object)new PacketTileData(fld.ordinal(), shape.ordinal(), ((ContainerStructure)this.field_147002_h).tile.func_174877_v()))));
            btnShape.setTooltip(shapeName);
            x += bsize;
            btnShape.setTileField(shape.ordinal());
            this.shapeBtuns.add(btnShape);
        }
    }

    public void removed() {
        this.txtHeight = null;
        this.txtSize = null;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.energy.renderHoveredToolTip(mouseX, mouseY, ((ContainerStructure)this.field_147002_h).getEnergy());
    }

    public void tick() {
        this.txtHeight.func_146178_a();
        this.txtSize.func_146178_a();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.btnRedstone.setTooltip(UtilChat.lang("gui.cyclic.redstone" + ((ContainerStructure)this.field_147002_h).tile.getNeedsRedstone()));
        this.btnRedstone.setTextureId(((ContainerStructure)this.field_147002_h).tile.getNeedsRedstone() == 1 ? TextureEnum.REDSTONE_NEEDED : TextureEnum.REDSTONE_ON);
        int on = ((ContainerStructure)this.field_147002_h).tile.getField(TileStructure.Fields.RENDER.ordinal());
        this.btnRender.setTooltip(UtilChat.lang("gui.cyclic.render" + on));
        this.btnRender.setTextureId(on == 1 ? TextureEnum.RENDER_SHOW : TextureEnum.RENDER_HIDE);
        this.drawButtonTooltips(mouseX, mouseY);
        this.drawName(this.title.func_150254_d());
        this.updateDisabledButtons();
    }

    private void updateDisabledButtons() {
        int shape = ((ContainerStructure)this.field_147002_h).tile.getField(TileStructure.Fields.BUILDTYPE.ordinal());
        for (ButtonMachine b : this.shapeBtuns) {
            b.active = b.getTileField() != shape;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(TextureRegistry.INVENTORY);
        this.drawSlot(60, 20);
        this.energy.draw(((ContainerStructure)this.field_147002_h).getEnergy());
        this.txtHeight.render(mouseX, mouseX, partialTicks);
        this.txtSize.render(mouseX, mouseX, partialTicks);
    }
}

