/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tankcask;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.tankcask.TileCask;
import com.lothrazar.cyclic.capability.FluidHandlerCapabilityStack;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockCask
extends BlockBase {
    public BlockCask(Block.Properties properties) {
        super(properties.harvestTool(ToolType.PICKAXE).func_200943_b(1.2f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCask();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        IFluidHandler handler;
        TileEntity tankHere;
        if (!world.field_72995_K && (tankHere = world.func_175625_s(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElse(null)) != null) {
            if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)handler)) {
                if (handler.getFluidInTank(0) != null) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("" + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0), new Object[0]), true);
                }
                if (player instanceof ServerPlayerEntity) {
                    UtilSound.playSoundFromServer((ServerPlayerEntity)player, SoundEvents.field_187630_M);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("" + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0), new Object[0]), true);
            }
        }
        if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)).isPresent()) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            IFluidHandler storageTile;
            IFluidHandlerItem storage = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            TileEntity container = world.func_175625_s(pos);
            if (storage != null && container != null && (storageTile = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null)) != null) {
                storageTile.fill(storage.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error during fill from item ", (Throwable)e);
        }
        world.func_175656_a(pos, state);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity ent, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, ent, stack);
        ItemStack tankStack = new ItemStack((IItemProvider)this);
        if (ent != null) {
            IFluidHandler fluidInTile = (IFluidHandler)ent.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
            IFluidHandler fluidInStack = (IFluidHandler)tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            if (fluidInStack != null) {
                FluidStack fs = fluidInTile.getFluidInTank(0);
                ((FluidHandlerCapabilityStack)fluidInStack).setFluid(fs);
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tankStack));
        }
    }
}

