/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilNBT;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantBeheading
extends EnchantBase {
    private Map<String, String> mapResourceToSkin = new HashMap<String, String>();
    private static final int percentDrop = 20;
    private static final int percentPerLevel = 25;

    public EnchantBeheading(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        this.buildDefaultHeadList();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void buildDefaultHeadList() {
        this.mapResourceToSkin = new HashMap<String, String>();
        this.mapResourceToSkin.put("minecraft:blaze", "MHF_Blaze");
        this.mapResourceToSkin.put("minecraft:cat", "MHF_Ocelot");
        this.mapResourceToSkin.put("minecraft:cave_spider", "MHF_CaveSpider");
        this.mapResourceToSkin.put("minecraft:chicken", "MHF_Chicken");
        this.mapResourceToSkin.put("minecraft:cow", "MHF_Cow");
        this.mapResourceToSkin.put("minecraft:enderman", "MHF_Enderman");
        this.mapResourceToSkin.put("minecraft:ghast", "MHF_Ghast");
        this.mapResourceToSkin.put("minecraft:iron_golem", "MHF_Golem");
        this.mapResourceToSkin.put("minecraft:magma_cube", "MHF_LavaSlime");
        this.mapResourceToSkin.put("minecraft:mooshroom", "MHF_MushroomCow");
        this.mapResourceToSkin.put("minecraft:ocelot", "MHF_Ocelot");
        this.mapResourceToSkin.put("minecraft:pig", "MHF_Pig");
        this.mapResourceToSkin.put("minecraft:zombie_pigman", "MHF_PigZombie");
        this.mapResourceToSkin.put("minecraft:sheep", "MHF_Sheep");
        this.mapResourceToSkin.put("minecraft:slime", "MHF_Slime");
        this.mapResourceToSkin.put("minecraft:spider", "MHF_Spider");
        this.mapResourceToSkin.put("minecraft:squid", "MHF_Squid");
        this.mapResourceToSkin.put("minecraft:villager", "MHF_Villager");
        this.mapResourceToSkin.put("minecraft:witch", "MHF_Witch");
        this.mapResourceToSkin.put("minecraft:wolf", "MHF_Wolf");
        this.mapResourceToSkin.put("minecraft:guardian", "MHF_Guardian");
        this.mapResourceToSkin.put("minecraft:elder_guardian", "MHF_Guardian");
        this.mapResourceToSkin.put("minecraft:snow_golem", "MHF_SnowGolem");
        this.mapResourceToSkin.put("minecraft:silverfish", "MHF_Silverfish");
        this.mapResourceToSkin.put("minecraft:endermite", "MHF_Endermite");
    }

    public int func_77325_b() {
        return 3;
    }

    private int percentForLevel(int level) {
        return 20 + (level - 1) * 25;
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
            int level = this.getCurrentLevelTool((LivingEntity)attacker);
            if (level <= 0) {
                return;
            }
            World world = attacker.field_70170_p;
            if (MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)100) > this.percentForLevel(level)) {
                return;
            }
            LivingEntity target = (LivingEntity)event.getEntity();
            if (target == null) {
                return;
            }
            BlockPos pos = target.func_180425_c();
            if (target instanceof PlayerEntity) {
                UtilItemStack.drop(world, pos, UtilNBT.buildNamedPlayerSkull((PlayerEntity)target));
                return;
            }
            String key = target.func_200600_R().getRegistryName().toString();
            if (this.mapResourceToSkin.containsKey(key)) {
                UtilItemStack.drop(world, pos, UtilNBT.buildNamedPlayerSkull(this.mapResourceToSkin.get(key)));
            } else if (target.func_200600_R() == EntityType.field_200802_p) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196151_dA));
            } else if (target.func_200600_R() == EntityType.field_200797_k) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196185_dy));
            } else if (target.func_200600_R() == EntityType.field_200725_aD) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196186_dz));
            } else if (target.func_200600_R() == EntityType.field_200741_ag) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196182_dv));
            } else if (target.func_200600_R() == EntityType.field_200722_aA) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196183_dw));
            } else {
                ModCyclic.LOGGER.error("Beheading : mob not found in EntityList " + target.func_200200_C_());
            }
        }
    }
}

