/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.boomerang;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.item.boomerang.BoomerangItem;
import com.lothrazar.cyclic.registry.PotionRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BoomerangEntity
extends ProjectileItemEntity {
    private static final int STUN_SECONDS = 7;
    private static final int TICKS_UNTIL_RETURN = 15;
    private static final int TICKS_UNTIL_DEATH = 900;
    private static final double SPEED = 0.95;
    static final float DAMAGE_MIN = 1.5f;
    static final float DAMAGE_MAX = 3.8f;
    private static final DataParameter<Byte> IS_RETURNING = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> REDSTONE_TRIGGERED = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<String> OWNER = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private ItemStack boomerangThrown = ItemStack.field_190927_a;
    private PlayerEntity targetEntity;
    protected BoomerangItem.Boomer boomerangType;

    public BoomerangEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public BoomerangEntity(EntityType<BoomerangEntity> type, LivingEntity throwerIn, World worldIn) {
        super(type, throwerIn, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_RETURNING, (Object)0);
        this.field_70180_af.func_187214_a(REDSTONE_TRIGGERED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER, (Object)"");
    }

    public void setBoomerangThrown(ItemStack boomerangThrown) {
        this.boomerangThrown = boomerangThrown;
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74778_a("OWNER", (String)this.field_70180_af.func_187225_a(OWNER));
        tag.func_74774_a("returning", ((Byte)this.field_70180_af.func_187225_a(IS_RETURNING)).byteValue());
        tag.func_74774_a("REDSTONE_TRIGGERED", ((Byte)this.field_70180_af.func_187225_a(REDSTONE_TRIGGERED)).byteValue());
        this.boomerangThrown.func_77955_b(tag);
        super.func_213281_b(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(OWNER, (Object)tag.func_74779_i("OWNER"));
        this.field_70180_af.func_187227_b(IS_RETURNING, (Object)tag.func_74771_c("returning"));
        this.field_70180_af.func_187227_b(REDSTONE_TRIGGERED, (Object)tag.func_74771_c("REDSTONE_TRIGGERED"));
        this.boomerangThrown = ItemStack.func_199557_a((CompoundNBT)tag);
        super.func_70037_a(tag);
    }

    public void setOwner(PlayerEntity ent) {
        this.targetEntity = ent;
        if (ent != null && ent.func_110124_au() != null) {
            this.field_70180_af.func_187227_b(OWNER, (Object)ent.func_110124_au().toString());
        }
    }

    private void movementReturnCheck() {
        boolean returning;
        boolean bl = returning = (Byte)this.field_70180_af.func_187225_a(IS_RETURNING) == 1;
        if (returning && this.targetEntity != null) {
            this.moveTowardsTarget();
        }
    }

    private void moveTowardsTarget() {
        this.field_70177_z = (float)Math.toRadians(UtilEntity.yawDegreesBetweenPoints(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_()));
        this.field_70125_A = (float)Math.toRadians(UtilEntity.pitchDegreesBetweenPoints(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_()));
        Vec3d moveVec = UtilEntity.lookVector(this.field_70177_z, this.field_70125_A).func_186678_a(0.95);
        this.func_213293_j(0.5 * this.func_213322_ci().func_82615_a() + 0.5 * moveVec.field_72450_a, 0.5 * this.func_213322_ci().func_82617_b() + (double)0.503f * moveVec.field_72448_b, 0.5 * this.func_213322_ci().func_82616_c() + 0.5 * moveVec.field_72449_c);
    }

    private void tryPickupNearby() {
        if (this.field_70192_c == null || this.field_70170_p.field_72995_K) {
            return;
        }
        boolean range = true;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_191194_a(this.func_213322_ci()).func_72314_b((double)range, (double)range, (double)range));
        for (Entity entityHit : list) {
            if (!(entityHit instanceof ItemEntity) && !(entityHit instanceof ExperienceOrbEntity)) continue;
            entityHit.func_70634_a(this.field_70192_c.func_226277_ct_(), this.field_70192_c.func_226278_cu_(), this.field_70192_c.func_226281_cx_());
        }
    }

    private void tryToggleRedstone(BlockPos pos) {
        if (this.field_70192_c instanceof PlayerEntity) {
            try {
                boolean hasTriggered;
                BlockState blockState = this.field_70170_p.func_180495_p(pos);
                Block block = blockState.func_177230_c();
                ActionResultType t = block.func_225533_a_(blockState, this.field_70170_p, pos, (PlayerEntity)this.field_70192_c, Hand.MAIN_HAND, null);
                boolean bl = hasTriggered = t == ActionResultType.SUCCESS;
                if (hasTriggered) {
                    this.setRedstoneHasTriggered();
                }
            }
            catch (Throwable e) {
                ModCyclic.LOGGER.error("Error on activate block", e);
            }
        }
    }

    private void setIsReturning() {
        this.field_70180_af.func_187227_b(IS_RETURNING, (Object)1);
    }

    private void setRedstoneHasTriggered() {
        this.field_70180_af.func_187227_b(REDSTONE_TRIGGERED, (Object)1);
    }

    private boolean hasTriggeredRedstoneAlready() {
        return (Byte)this.field_70180_af.func_187225_a(REDSTONE_TRIGGERED) > 0;
    }

    private void dropAsItem() {
        if (!this.boomerangThrown.func_190926_b()) {
            if (this.field_70192_c != null) {
                if (this.field_70192_c.func_184614_ca().func_190926_b()) {
                    this.field_70192_c.func_184611_a(Hand.MAIN_HAND, this.boomerangThrown);
                    this.boomerangThrown = ItemStack.field_190927_a;
                } else {
                    this.field_70192_c.func_70099_a(this.boomerangThrown, 0.5f);
                    this.boomerangThrown = ItemStack.field_190927_a;
                }
            } else {
                UtilItemStack.drop(this.field_70170_p, this.func_180425_c().func_177984_a(), this.boomerangThrown);
                this.boomerangThrown = ItemStack.field_190927_a;
            }
        }
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 900) {
            this.dropAsItem();
            return;
        }
        if (this.field_70173_aa > 15) {
            this.setIsReturning();
        }
        BlockPos pos = this.func_180425_c();
        if (this.field_70192_c != null && UtilWorld.distanceBetweenHorizontal(pos, this.field_70192_c.func_180425_c()) < 1.0) {
            this.dropAsItem();
            return;
        }
        if (!this.hasTriggeredRedstoneAlready() && !this.field_70170_p.func_175623_d(pos)) {
            this.tryToggleRedstone(pos);
        }
        this.tryPickupNearby();
        this.movementReturnCheck();
    }

    protected void func_70184_a(RayTraceResult result) {
        switch (result.func_216346_c()) {
            case BLOCK: {
                this.onImpactBlock((BlockRayTraceResult)result);
                break;
            }
            case ENTITY: {
                this.onImpactEntity((EntityRayTraceResult)result);
                break;
            }
        }
    }

    private void onImpactBlock(BlockRayTraceResult mop) {
        BlockState block = this.field_70170_p.func_180495_p(mop.func_216350_a());
        if (mop.func_216354_b() != Direction.UP && block.func_224755_d((IBlockReader)this.func_130014_f_(), mop.func_216350_a(), mop.func_216354_b())) {
            this.setIsReturning();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onImpactEntity(EntityRayTraceResult entityRayTrace) {
        Entity entityHit = entityRayTrace.func_216348_a();
        if (entityHit == null || !entityHit.func_70089_S()) {
            return;
        }
        if (this.field_70192_c == entityHit) {
            this.dropAsItem();
            return;
        }
        switch (this.boomerangType) {
            case CARRY: {
                entityHit.func_184220_m((Entity)this);
                return;
            }
            case DAMAGE: {
                if (!(entityHit instanceof LivingEntity)) return;
                LivingEntity live = (LivingEntity)entityHit;
                float damage = MathHelper.func_151240_a((Random)this.field_70170_p.field_73012_v, (float)1.5f, (float)3.8f);
                boolean attackSucc = live.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
                if (attackSucc && live.func_70089_S()) return;
            }
            case STUN: {
                LivingEntity live;
                if (entityHit == this.field_70192_c || !(entityHit instanceof LivingEntity) || (live = (LivingEntity)entityHit).func_70644_a((Effect)PotionRegistry.PotionEffects.stun)) return;
                live.func_195064_c(new EffectInstance((Effect)PotionRegistry.PotionEffects.stun, 140, 1));
                UtilSound.playSound((Entity)live, live.func_180425_c(), SoundEvents.field_187596_cD);
                return;
            }
        }
    }

    protected float func_70185_h() {
        return -0.02f;
    }

    protected Item func_213885_i() {
        return null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

