/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.jei;

import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.RecipeMelter;
import com.lothrazar.cyclic.block.melter.ScreenMelter;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.block.solidifier.ScreenSolidifier;
import com.lothrazar.cyclic.jei.MelterRecipeCategory;
import com.lothrazar.cyclic.jei.SolidifierRecipeCategory;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class CyclicJEI
implements IModPlugin {
    private ResourceLocation id = new ResourceLocation("cyclic", "jei");

    public ResourceLocation getPluginUid() {
        return this.id;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolidifierRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(RecipeMelter.RECIPES, MelterRecipeCategory.id);
        registry.addRecipes(RecipeSolidifier.RECIPES, SolidifierRecipeCategory.id);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenMelter.class, 75, 20, 40, 26, new ResourceLocation[]{MelterRecipeCategory.id});
        registry.addRecipeClickArea(ScreenSolidifier.class, 75, 20, 40, 26, new ResourceLocation[]{SolidifierRecipeCategory.id});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMelter.class, MelterRecipeCategory.id, 0, 2, 2, 36);
        registry.addRecipeTransferHandler(ContainerSolidifier.class, SolidifierRecipeCategory.id, 0, 3, 3, 36);
    }
}

