/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.registry;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.command.CommandGetHome;
import com.lothrazar.cyclic.command.CommandHealth;
import com.lothrazar.cyclic.command.CommandHome;
import com.lothrazar.cyclic.command.CommandHunger;
import com.lothrazar.cyclic.command.CommandNbt;
import com.lothrazar.cyclic.command.CommandNetherping;
import com.lothrazar.cyclic.command.CommandWorldspawn;
import com.lothrazar.cyclic.command.ICyclicCommand;
import com.lothrazar.cyclic.util.UtilChat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class CommandRegistry {
    public static final List<String> SUBCOMMANDS = new ArrayList<String>();
    public static final List<ICyclicCommand> COMMANDS = new ArrayList<ICyclicCommand>();

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        COMMANDS.add(new CommandGetHome());
        COMMANDS.add(new CommandHealth());
        COMMANDS.add(new CommandHome());
        COMMANDS.add(new CommandHunger());
        COMMANDS.add(new CommandNbt());
        COMMANDS.add(new CommandNetherping());
        COMMANDS.add(new CommandWorldspawn());
        for (ICyclicCommand cmd : COMMANDS) {
            SUBCOMMANDS.add(cmd.getName());
        }
        CommandDispatcher r = event.getCommandDispatcher();
        r.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"cyclic").then(Commands.func_197056_a((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(this::execute))).executes(this::execute));
    }

    private int execute(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        List<String> arguments = Arrays.asList(ctx.getInput().split("\\s+"));
        if (arguments.size() < 2) {
            this.badCommandMsg(player);
            return 0;
        }
        String sub = arguments.get(1);
        for (ICyclicCommand cmd : COMMANDS) {
            boolean isOp;
            if (!sub.equalsIgnoreCase(cmd.getName())) continue;
            if (cmd.needsOp() && !(isOp = ((CommandSource)ctx.getSource()).func_197034_c(1))) {
                ModCyclic.LOGGER.info("Player [" + player.func_208017_dF().func_150254_d() + "] attempted /cyclic command " + sub + " but does not have the required permissions");
                UtilChat.sendFeedback(ctx, "commands.help.failed");
                return 1;
            }
            return cmd.execute(ctx, arguments.subList(2, arguments.size()), (PlayerEntity)player);
        }
        this.badCommandMsg(player);
        return 0;
    }

    private void badCommandMsg(ServerPlayerEntity player) {
        UtilChat.addServerChatMessage((PlayerEntity)player, UtilChat.lang("command.cyclic.arguments.null") + "[" + String.join((CharSequence)", ", SUBCOMMANDS) + "]");
    }
}

