/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.BarPanelBlock;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChainBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.LatticeBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.PillarBlock;
import lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockWrapper;
import lilypuree.decorative_blocks.registration.DBNames;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class DBBlocks {
    public static final BlockWrapper<BonfireBlock> BONFIRE;
    public static final BlockWrapper<ChandelierBlock> CHANDELIER;
    public static final BlockWrapper<BrazierBlock> BRAZIER;
    public static final BlockWrapper<ChandelierBlock> SOUL_CHANDELIER;
    public static final BlockWrapper<BrazierBlock> SOUL_BRAZIER;
    public static final BlockWrapper<BonfireBlock> SOUL_BONFIRE;
    public static final BlockWrapper<BarPanelBlock> BAR_PANEL;
    public static final BlockWrapper<LatticeBlock> LATTICE;
    public static final BlockWrapper<ChainBlock> CHAIN;
    public static final BlockWrapper<PillarBlock> STONE_PILLAR;
    public static final BlockWrapper<RockyDirtBlock> ROCKY_DIRT;
    public static final ImmutableMap<class_4719, BlockWrapper<BeamBlock>> BEAMS;
    public static final ImmutableMap<class_4719, BlockWrapper<PalisadeBlock>> PALISADES;
    public static final ImmutableMap<class_4719, BlockWrapper<SupportBlock>> SUPPORTS;
    public static final ImmutableMap<class_4719, BlockWrapper<SeatBlock>> SEATS;

    public static void init() {
    }

    public static IWoodenBlock createDecorativeBlock(class_4719 wood, class_3620 mapColor, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        class_4970.class_2251 properties = class_4970.class_2251.method_9637().method_31710(mapColor).method_9626(wood.comp_1301());
        if (!VanillaWoodTypes.isNetherWood(wood)) {
            properties.method_50013();
        }
        if (woodDecorativeBlockType == WoodDecorativeBlockTypes.PALISADE) {
            properties.method_9629(2.0f, 4.0f);
        } else {
            properties.method_9632(1.2f);
        }
        return woodDecorativeBlockType.create(wood, properties);
    }

    private static <T extends class_2248> BlockWrapper<T> registerBlock(String name, Supplier<T> blockSupplier) {
        return new BlockWrapper<T>(Services.PLATFORM.register(class_7923.field_41175, name, blockSupplier));
    }

    static {
        class_4970.class_2251 chainProperties = class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_9632(4.3f).method_9626(class_2498.field_11533).method_22488();
        class_4970.class_2251 bonfire = class_4970.class_2251.method_9637().method_9626(class_2498.field_11543).method_9632(0.0f).method_31710(class_3620.field_16002).method_50012(class_3619.field_15971).method_51371().method_9634().method_9631(state -> 15).method_42327();
        class_4970.class_2251 soul_bonfire = class_4970.class_2251.method_9637().method_9626(class_2498.field_11543).method_9632(0.0f).method_31710(class_3620.field_16026).method_50012(class_3619.field_15971).method_51371().method_9634().method_9631(state -> 14).method_42327();
        class_4970.class_2251 chandelier = class_4970.class_2251.method_9637().method_9626(class_2498.field_11547).method_9632(0.3f).method_50012(class_3619.field_15971).method_51371().method_9634().method_22488().method_9631(state -> 15);
        class_4970.class_2251 soul_chandelier = class_4970.class_2251.method_9637().method_9626(class_2498.field_11547).method_9632(0.3f).method_50012(class_3619.field_15971).method_51371().method_9634().method_22488().method_9631(state -> 11);
        class_4970.class_2251 brazier = class_4970.class_2251.method_9637().method_9626(class_2498.field_11533).method_9632(3.0f).method_31710(class_3620.field_16005).method_22488().method_9631(state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? 15 : 0);
        class_4970.class_2251 soul_brazier = class_4970.class_2251.method_9637().method_9626(class_2498.field_11533).method_9632(3.0f).method_31710(class_3620.field_16005).method_22488().method_9631(state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? 10 : 0);
        class_4970.class_2251 bar_panel = class_4970.class_2251.method_9637().method_9626(class_2498.field_11533).method_9632(5.0f).method_31710(class_3620.field_16005).method_22488();
        class_4970.class_2251 lattice = class_4970.class_2251.method_9637().method_9626(class_2498.field_11547).method_9632(1.2f).method_31710(class_3620.field_15996).method_22488();
        class_4970.class_2251 pillar = class_4970.class_2251.method_9637().method_9626(class_2498.field_11544).method_9629(1.5f, 6.5f).method_31710(class_3620.field_16023);
        BONFIRE = DBBlocks.registerBlock("bonfire", () -> new BonfireBlock(bonfire));
        CHANDELIER = DBBlocks.registerBlock("chandelier", () -> new ChandelierBlock(chandelier, false));
        BRAZIER = DBBlocks.registerBlock("brazier", () -> new BrazierBlock(brazier, false));
        SOUL_BONFIRE = DBBlocks.registerBlock("soul_bonfire", () -> new BonfireBlock(soul_bonfire));
        SOUL_CHANDELIER = DBBlocks.registerBlock("soul_chandelier", () -> new ChandelierBlock(soul_chandelier, true));
        SOUL_BRAZIER = DBBlocks.registerBlock("soul_brazier", () -> new BrazierBlock(soul_brazier, true));
        BAR_PANEL = DBBlocks.registerBlock("bar_panel", () -> new BarPanelBlock(bar_panel));
        LATTICE = DBBlocks.registerBlock("lattice", () -> new LatticeBlock(lattice));
        CHAIN = DBBlocks.registerBlock("chain", () -> new ChainBlock(chainProperties));
        STONE_PILLAR = DBBlocks.registerBlock("stone_pillar", () -> new PillarBlock(pillar));
        ROCKY_DIRT = DBBlocks.registerBlock("rocky_dirt", RockyDirtBlock::new);
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (class_4719 woodType : VanillaWoodTypes.VANILLA) {
            class_3620 mapColor = VanillaWoodTypes.getPlanks(woodType).method_26403();
            if (woodType != class_4719.field_40350) {
                beams.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.BEAM), () -> (BeamBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.BEAM)));
            }
            palisades.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.PALISADE), () -> (PalisadeBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.PALISADE)));
            supports.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> (SupportBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.SUPPORT)));
            seats.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> (SeatBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.SEAT)));
        }
        BEAMS = beams.build();
        PALISADES = palisades.build();
        SUPPORTS = supports.build();
        SEATS = seats.build();
    }
}

