/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.items.BlockstateCopyItem;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockWrapper;
import lilypuree.decorative_blocks.registration.DBBlocks;
import lilypuree.decorative_blocks.registration.DBNames;
import lilypuree.decorative_blocks.registration.ItemWrapper;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_4719;
import net.minecraft.class_7923;

public class DBItems {
    public static final ItemWrapper<class_1747> CHANDELIER = DBItems.registerBlockItem("chandelier", DBBlocks.CHANDELIER);
    public static final ItemWrapper<class_1747> SOUL_CHANDELIER = DBItems.registerBlockItem("soul_chandelier", DBBlocks.SOUL_CHANDELIER);
    public static final ItemWrapper<class_1747> BRAZIER = DBItems.registerBlockItem("brazier", DBBlocks.BRAZIER);
    public static final ItemWrapper<class_1747> SOUL_BRAZIER = DBItems.registerBlockItem("soul_brazier", DBBlocks.SOUL_BRAZIER);
    public static final ItemWrapper<class_1747> BAR_PANEL = DBItems.registerBlockItem("bar_panel", DBBlocks.BAR_PANEL);
    public static final ItemWrapper<class_1747> LATTICE = DBItems.registerBlockItem("lattice", DBBlocks.LATTICE);
    public static final ItemWrapper<class_1747> CHAIN = DBItems.registerBlockItem("chain", DBBlocks.CHAIN);
    public static final ItemWrapper<class_1747> STONE_PILLAR = DBItems.registerBlockItem("stone_pillar", DBBlocks.STONE_PILLAR);
    public static final ItemWrapper<class_1747> ROCKY_DIRT = DBItems.registerBlockItem("rocky_dirt", DBBlocks.ROCKY_DIRT);
    public static final ItemWrapper<class_1792> BLOCKSTATE_COPY_ITEM = DBItems.registerItem("blockstate_copy_item", () -> new BlockstateCopyItem(new class_1792.class_1793().method_7889(1)));
    public static final ImmutableMap<class_4719, ItemWrapper<class_1747>> BEAM_ITEMBLOCKS;
    public static final ImmutableMap<class_4719, ItemWrapper<SeatItem>> SEAT_ITEMBLOCKS;
    public static final ImmutableMap<class_4719, ItemWrapper<SupportItem>> SUPPORT_ITEMBLOCKS;
    public static final ImmutableMap<class_4719, ItemWrapper<class_1747>> PALISADE_ITEMBLOCKS;

    public static void init() {
    }

    private static <T extends class_1792> ItemWrapper<T> registerItem(String name, Supplier<T> itemSupplier) {
        return new ItemWrapper<T>(Services.PLATFORM.register(class_7923.field_41178, name, itemSupplier));
    }

    private static ItemWrapper<class_1747> registerBlockItem(String name, BlockWrapper<?> block) {
        return DBItems.registerItem(name, () -> new class_1747(block.get(), new class_1792.class_1793()));
    }

    static {
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (class_4719 woodType : VanillaWoodTypes.VANILLA) {
            if (woodType != class_4719.field_40350) {
                beams.put((Object)woodType, DBItems.registerBlockItem(DBNames.name(woodType, WoodDecorativeBlockTypes.BEAM), (BlockWrapper)DBBlocks.BEAMS.get((Object)woodType)));
            }
            seats.put((Object)woodType, DBItems.registerItem(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> new SeatItem((class_2248)((BlockWrapper)DBBlocks.SEATS.get((Object)woodType)).get(), new class_1792.class_1793())));
            supports.put((Object)woodType, DBItems.registerItem(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> new SupportItem((class_2248)((BlockWrapper)DBBlocks.SUPPORTS.get((Object)woodType)).get(), new class_1792.class_1793())));
            palisades.put((Object)woodType, DBItems.registerBlockItem(DBNames.name(woodType, WoodDecorativeBlockTypes.PALISADE), (BlockWrapper)DBBlocks.PALISADES.get((Object)woodType)));
        }
        BEAM_ITEMBLOCKS = beams.build();
        PALISADE_ITEMBLOCKS = palisades.build();
        SUPPORT_ITEMBLOCKS = supports.build();
        SEAT_ITEMBLOCKS = seats.build();
    }
}

