/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import java.util.Random;
import lilypuree.decorative_blocks.core.DBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrazierBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape BRAZIER_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    protected static final VoxelShape BRAZIER_COLLISION_SHAPE = Block.m_49796_((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)13.5, (double)13.5);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final boolean isSoul;

    public BrazierBlock(BlockBehaviour.Properties properties, boolean isSoul) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.TRUE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.isSoul = isSoul;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.m_5825_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn)) && entityIn.m_20186_() >= state.m_60812_((BlockGetter)worldIn, pos).m_83297_(Direction.Axis.Y) + (double)pos.m_123342_() - (double)0.1f) {
            entityIn.m_6469_(DamageSource.f_19305_, 1.0f);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level iworld = context.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (heldItem.m_41720_() instanceof ShovelItem) {
                worldIn.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.8f, 1.0f);
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
                return InteractionResult.SUCCESS;
            }
        } else if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && (hit.m_82434_() == Direction.UP && heldItem.m_41720_() == Items.f_42409_ || heldItem.m_41720_() == Items.f_42613_)) {
            SoundEvent sound = heldItem.m_41720_() == Items.f_42613_ ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            worldIn.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, worldIn.f_46441_.nextFloat() * 0.4f + 0.8f);
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BRAZIER_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BRAZIER_COLLISION_SHAPE;
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    if (this.isSoul) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.8f), (double)((float)pos.m_123343_() + 0.5f), (double)((rand.nextFloat() - 0.5f) / 10.0f), (double)(rand.nextFloat() / 5.0f), ((double)rand.nextFloat() - 0.5) / 10.0);
                        continue;
                    }
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.8f), (double)((float)pos.m_123343_() + 0.5f), (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.m_82425_();
        if (!worldIn.f_46443_ && projectile.m_6060_() && projectile.m_142265_(worldIn, pos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
        }
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            boolean flag = (Boolean)state.m_61143_((Property)LIT);
            if (flag) {
                worldIn.m_5594_((Player)null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static boolean isLitBrazier(BlockState blockState) {
        return blockState.m_61138_((Property)LIT) && blockState.m_204336_(DBTags.Blocks.BRAZIERS) && (Boolean)blockState.m_61143_((Property)LIT) != false;
    }
}

