/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import java.util.function.Consumer;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DBRecipes
extends RecipeProvider {
    public DBRecipes(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        for (VanillaWoodTypes wood : VanillaWoodTypes.values()) {
            DBRecipes.makeWoodenBlockRecipes(wood, consumer);
        }
        ShapedRecipeBuilder.m_126118_((ItemLike)DBBlocks.BAR_PANEL, (int)2).m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42025_).m_142284_("has_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42416_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)DBBlocks.LATTICE, (int)1).m_126130_(" # ").m_126130_("# #").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_142284_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42398_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)DBBlocks.ROCKY_DIRT, (int)1).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42329_).m_142284_("has_dirt", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42329_})).m_176498_(consumer);
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50069_}), (ItemLike)DBBlocks.STONE_PILLAR).m_142284_("has_stone", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_41905_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)DBBlocks.BRAZIER).m_142409_("decorative_braziers").m_126130_("010").m_126130_(" 0 ").m_126127_(Character.valueOf('0'), (ItemLike)Items.f_42025_).m_206416_(Character.valueOf('1'), ItemTags.f_13160_).m_142284_("has_bar", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42025_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)DBBlocks.SOUL_BRAZIER).m_142409_("decorative_braziers").m_126130_(" 1 ").m_126130_("020").m_126130_(" 0 ").m_126127_(Character.valueOf('0'), (ItemLike)Items.f_42025_).m_206416_(Character.valueOf('1'), ItemTags.f_13160_).m_206416_(Character.valueOf('2'), ItemTags.f_13154_).m_142284_("has_bar", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42025_})).m_176498_(consumer);
        DBRecipes.makeChandelierRecipeOf(DBBlocks.CHANDELIER, Items.f_42000_, consumer);
        DBRecipes.makeChandelierRecipeOf(DBBlocks.SOUL_CHANDELIER, Items.f_42053_, consumer);
    }

    public static void makeWoodenBlockRecipes(IWoodType woodType, Consumer<FinishedRecipe> consumer) {
        DBRecipes.makeBeamRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.BEAM), consumer);
        DBRecipes.makePalisadeRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.PALISADE), consumer);
        DBRecipes.makeSeatRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.SEAT), consumer);
        DBRecipes.makeSupportRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.SUPPORT), consumer);
    }

    public static IWoodenBlock getBlock(IWoodType woodType, WoodDecorativeBlockTypes type) {
        return Registry.f_122824_.m_123024_().filter(block -> {
            if (block instanceof IWoodenBlock && ((IWoodenBlock)block).getWoodType() == woodType) {
                switch (type) {
                    case SEAT: {
                        return block instanceof SeatBlock;
                    }
                    case BEAM: {
                        return block instanceof BeamBlock;
                    }
                    case PALISADE: {
                        return block instanceof PalisadeBlock;
                    }
                    case SUPPORT: {
                        return block instanceof SupportBlock;
                    }
                }
            }
            return false;
        }).findFirst().orElse(null);
    }

    public static void makeChandelierRecipeOf(Block chandelier, Item torch, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)chandelier).m_142409_("decorative_chandeliers").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)torch).m_142284_("has_torch", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{torch})).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)torch, (int)4).m_142409_("torches_from_chandeliers").m_126209_((ItemLike)chandelier).m_142284_("has_torch", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{torch})).m_176500_(consumer, "decorative_blocks:" + torch.getRegistryName().m_135815_() + "_from_" + chandelier.getRegistryName().m_135815_());
    }

    public static void makeBeamRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        ShapedRecipeBuilder.m_126118_((ItemLike)((Block)block), (int)2).m_142409_("decorative_beams").m_126130_(" x ").m_126130_(" x ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getStrippedLog()).m_142284_("has_stripped_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{wood.getStrippedLog()})).m_176498_(consumer);
    }

    public static void makePalisadeRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        ShapedRecipeBuilder.m_126118_((ItemLike)((Block)block), (int)6).m_142409_("decorative_palisades").m_126130_("xx ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getLog()).m_142284_("has_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{wood.getLog()})).m_176498_(consumer);
    }

    public static void makeSeatRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        ShapedRecipeBuilder.m_126118_((ItemLike)((Block)block), (int)2).m_142409_("decorative_seats").m_126130_("x  ").m_126130_("y  ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getSlab()).m_126127_(Character.valueOf('y'), (ItemLike)wood.getFence()).m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{wood.getPlanks()})).m_176498_(consumer);
    }

    public static void makeSupportRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        ShapedRecipeBuilder.m_126118_((ItemLike)((Block)block), (int)3).m_142409_("decorative_supports").m_142409_("support").m_126130_("xx ").m_126130_("x  ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getPlanks()).m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{wood.getPlanks()})).m_176498_(consumer);
    }
}

