/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.core.DBNames;
import lilypuree.decorative_blocks.items.BlockstateCopyItem;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockRegistryObject;
import lilypuree.decorative_blocks.registration.RegistrationProvider;
import lilypuree.decorative_blocks.registration.RegistryObject;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class DBItems {
    private static final RegistrationProvider<Item> ITEM_REGISTRY = RegistrationProvider.get(Registry.f_122827_, "decorative_blocks");
    public static final CreativeModeTab ITEM_GROUP = Services.PLATFORM.createModTab("general", () -> new ItemStack((ItemLike)BRAZIER.get()));
    public static final RegistryObject<Item> CHANDELIER;
    public static final RegistryObject<Item> SOUL_CHANDELIER;
    public static final RegistryObject<Item> BRAZIER;
    public static final RegistryObject<Item> SOUL_BRAZIER;
    public static final RegistryObject<Item> BAR_PANEL;
    public static final RegistryObject<Item> LATTICE;
    public static final RegistryObject<Item> CHAIN;
    public static final RegistryObject<Item> STONE_PILLAR;
    public static final RegistryObject<Item> ROCKY_DIRT;
    public static final RegistryObject<Item> BLOCKSTATE_COPY_ITEM;
    public static final ImmutableMap<IWoodType, RegistryObject<Item>> BEAM_ITEMBLOCKS;
    public static final ImmutableMap<IWoodType, RegistryObject<Item>> SEAT_ITEMBLOCKS;
    public static final ImmutableMap<IWoodType, RegistryObject<Item>> SUPPORT_ITEMBLOCKS;
    public static final ImmutableMap<IWoodType, RegistryObject<Item>> PALISADE_ITEMBLOCKS;
    public static final Item.Properties modItemProperties;

    public static void init() {
    }

    private static RegistryObject<Item> registerItem(String name, Supplier<Item> itemSupplier) {
        return ITEM_REGISTRY.register(name, itemSupplier);
    }

    private static RegistryObject<Item> registerBlockItem(BlockRegistryObject<?> block) {
        return ITEM_REGISTRY.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), modItemProperties));
    }

    static {
        modItemProperties = new Item.Properties().m_41491_(ITEM_GROUP);
        CHANDELIER = DBItems.registerBlockItem(DBBlocks.CHANDELIER);
        SOUL_CHANDELIER = DBItems.registerBlockItem(DBBlocks.SOUL_CHANDELIER);
        BRAZIER = DBItems.registerBlockItem(DBBlocks.BRAZIER);
        SOUL_BRAZIER = DBItems.registerBlockItem(DBBlocks.SOUL_BRAZIER);
        BAR_PANEL = DBItems.registerBlockItem(DBBlocks.BAR_PANEL);
        LATTICE = DBItems.registerBlockItem(DBBlocks.LATTICE);
        CHAIN = DBItems.registerBlockItem(DBBlocks.CHAIN);
        STONE_PILLAR = DBItems.registerBlockItem(DBBlocks.STONE_PILLAR);
        ROCKY_DIRT = DBItems.registerBlockItem(DBBlocks.ROCKY_DIRT);
        BLOCKSTATE_COPY_ITEM = DBItems.registerItem("blockstate_copy_item", () -> new BlockstateCopyItem(new Item.Properties().m_41487_(1)));
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (VanillaWoodTypes woodType : VanillaWoodTypes.values()) {
            beams.put((Object)woodType, DBItems.registerBlockItem((BlockRegistryObject)DBBlocks.BEAMS.get((Object)woodType)));
            seats.put((Object)woodType, DBItems.registerItem(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> new SeatItem((Block)((BlockRegistryObject)DBBlocks.SEATS.get((Object)woodType)).get(), modItemProperties)));
            supports.put((Object)woodType, DBItems.registerItem(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> new SupportItem((Block)((BlockRegistryObject)DBBlocks.SUPPORTS.get((Object)woodType)).get(), modItemProperties)));
            palisades.put((Object)woodType, DBItems.registerBlockItem((BlockRegistryObject)DBBlocks.PALISADES.get((Object)woodType)));
        }
        BEAM_ITEMBLOCKS = beams.build();
        PALISADE_ITEMBLOCKS = palisades.build();
        SUPPORT_ITEMBLOCKS = supports.build();
        SEAT_ITEMBLOCKS = seats.build();
    }
}

