/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core.setup;

import lilypuree.decorative_blocks.CommonAPI;
import lilypuree.decorative_blocks.CommonConfig;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.core.DBItems;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.items.BlockstateCopyItem;
import lilypuree.decorative_blocks.mixin.FireBlockInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;

public class ModSetup {
    private static Item bonfireActivatorItem = null;

    public static void init() {
        CommonAPI.addThatchlikeFluid(Registration.referenceHolder);
        CommonAPI.bonfireMap.put(Blocks.f_50083_, (Block)DBBlocks.BONFIRE.get());
        CommonAPI.bonfireMap.put(Blocks.f_50084_, (Block)DBBlocks.SOUL_BONFIRE.get());
        Registry.f_122824_.forEach(block -> {
            if (block instanceof PalisadeBlock) {
                BlockstateCopyItem.addProperties(block, new Property[]{PalisadeBlock.f_52309_, PalisadeBlock.f_52310_, PalisadeBlock.f_52311_, PalisadeBlock.f_52312_});
            } else if (block instanceof SeatBlock) {
                BlockstateCopyItem.addProperties(block, new Property[]{SeatBlock.f_54117_, SeatBlock.POST, SeatBlock.ATTACHED});
            } else if (block instanceof SupportBlock) {
                BlockstateCopyItem.addProperties(block, new Property[]{SupportBlock.HORIZONTAL_SHAPE, SupportBlock.VERTICAL_SHAPE, SupportBlock.f_54117_, SupportBlock.UP});
            }
        });
        FireBlockInvoker invoker = (FireBlockInvoker)Blocks.f_50083_;
        Registry.f_122824_.forEach(block -> {
            IWoodenBlock woodenBlock;
            if (block instanceof IWoodenBlock && (woodenBlock = (IWoodenBlock)block).getWoodType().isFlammable()) {
                invoker.invokeSetFlammable((Block)block, 5, 20);
            }
        });
        invoker.invokeSetFlammable((Block)DBBlocks.LATTICE.get(), 5, 20);
        invoker.invokeSetFlammable((Block)DBBlocks.THATCH.get(), 60, 80);
    }

    public static boolean onLeftClick(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof BonfireBlock) {
            world.m_5898_(null, 1009, pos, 0);
            world.m_7471_(pos, false);
            return true;
        }
        return false;
    }

    public static int onRightClick(Level world, Player player, InteractionHand hand, ItemStack itemStack, BlockPos pos) {
        if (!world.m_46805_(pos)) {
            return 0;
        }
        Block block = world.m_8055_(pos).m_60734_();
        Item item = itemStack.m_41720_();
        if (item == Items.f_42574_ && CommonAPI.shearMap.containsKey(block)) {
            if (world.f_46443_) {
                player.m_6674_(hand);
            } else if (CommonConfig.THATCH_ENABLED) {
                world.m_46597_(pos, CommonAPI.shearMap.get(block).getLiquidBlock().m_49966_());
                world.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.2f, 1.0f);
                itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        if (item == DBItems.BLOCKSTATE_COPY_ITEM) {
            return -1;
        }
        return 0;
    }

    public static boolean isBonfireActivator(ItemStack item) {
        if (bonfireActivatorItem == null) {
            ModSetup.checkBonfireActivatorConfig();
            return ModSetup.isBonfireActivator(item);
        }
        return bonfireActivatorItem != Items.f_41852_ && bonfireActivatorItem == item.m_41720_();
    }

    public static boolean sendMessageOnThrow(Player player, ItemEntity thrown) {
        if (bonfireActivatorItem == null && !ModSetup.checkBonfireActivatorConfig()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.decorative_blocks.invalid_bonfire_activator_config"));
            return false;
        }
        return ModSetup.isBonfireActivator(thrown.m_32055_());
    }

    public static boolean checkBonfireActivatorConfig() {
        ResourceLocation bonfireActivatorResourceLocation = ResourceLocation.m_135820_((String)CommonConfig.BONFIRE_ACTIVATOR);
        if (bonfireActivatorResourceLocation != null && Registry.f_122827_.m_7804_(bonfireActivatorResourceLocation)) {
            bonfireActivatorItem = (Item)Registry.f_122827_.m_7745_(bonfireActivatorResourceLocation);
            return true;
        }
        bonfireActivatorItem = Items.f_41852_;
        return false;
    }
}

