/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import lilypuree.decorative_blocks.client.FogHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DBFluidType
extends FluidType {
    private final ResourceLocation flowingTexture;
    private final ResourceLocation stillTexture;
    private final ResourceLocation overlayTexture;
    private final int fogColor;

    public DBFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlayTexture, int fogColor) {
        super(properties);
        this.flowingTexture = flowingTexture;
        this.stillTexture = stillTexture;
        this.overlayTexture = overlayTexture;
        this.fogColor = fogColor;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getFlowingTexture() {
                return DBFluidType.this.flowingTexture;
            }

            public ResourceLocation getStillTexture() {
                return DBFluidType.this.stillTexture;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return DBFluidType.this.overlayTexture;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                FogHelper.Info colorInfo = FogHelper.decodeColor(DBFluidType.this.fogColor);
                return new Vector3f(colorInfo.fogRed(), colorInfo.fogGreen(), colorInfo.fogBlue());
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                FogHelper.onFogSetup(camera.m_90592_(), farDistance);
            }
        });
    }
}

