/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import lilypuree.decorative_blocks.registration.DBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrazierBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape BRAZIER_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    protected static final VoxelShape BRAZIER_COLLISION_SHAPE = Block.box((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)13.5, (double)13.5);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final boolean isSoul;

    public BrazierBlock(BlockBehaviour.Properties properties, boolean isSoul) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.isSoul = isSoul;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.fireImmune() && ((Boolean)state.getValue((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.hasFrostWalker((LivingEntity)((LivingEntity)entityIn)) && entityIn.getY() >= state.getCollisionShape((BlockGetter)worldIn, pos).max(Direction.Axis.Y) + (double)pos.getY() - (double)0.1f) {
            entityIn.hurt(entityIn.damageSources().inFire(), 1.0f);
        }
        super.entityInside(state, worldIn, pos, entityIn);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos;
        Level iworld = context.getLevel();
        boolean flag = iworld.getFluidState(blockpos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (heldItem.getItem() instanceof ShovelItem) {
                worldIn.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.8f, 1.0f);
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.FALSE));
                return InteractionResult.SUCCESS;
            }
        } else if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && (hit.getDirection() == Direction.UP && heldItem.getItem() == Items.FLINT_AND_STEEL || heldItem.getItem() == Items.FIRE_CHARGE)) {
            SoundEvent sound = heldItem.getItem() == Items.FIRE_CHARGE ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE;
            worldIn.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, worldIn.random.nextFloat() * 0.4f + 0.8f);
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.CONSUME;
        }
        return super.use(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BRAZIER_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BRAZIER_COLLISION_SHAPE;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    if (this.isSoul) {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.SOUL, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.8f), (double)((float)pos.getZ() + 0.5f), (double)((rand.nextFloat() - 0.5f) / 10.0f), (double)(rand.nextFloat() / 5.0f), ((double)rand.nextFloat() - 0.5) / 10.0);
                        continue;
                    }
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.8f), (double)((float)pos.getZ() + 0.5f), (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.getBlockPos();
        if (!worldIn.isClientSide && projectile.isOnFire() && projectile.mayInteract(worldIn, pos) && !((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
        }
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidStateIn.getType() == Fluids.WATER) {
            boolean flag = (Boolean)state.getValue((Property)LIT);
            if (flag) {
                worldIn.playSound((Player)null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static boolean isLitBrazier(BlockState blockState) {
        return blockState.hasProperty((Property)LIT) && blockState.is(DBTags.Blocks.BRAZIERS) && (Boolean)blockState.getValue((Property)LIT) != false;
    }
}

