/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks.types;

import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.WoodType;

public class VanillaWoodTypes {
    public static Set<WoodType> VANILLA = Set.of(WoodType.OAK, WoodType.SPRUCE, WoodType.BIRCH, WoodType.ACACIA, WoodType.CHERRY, WoodType.JUNGLE, WoodType.DARK_OAK, WoodType.CRIMSON, WoodType.WARPED, WoodType.MANGROVE, WoodType.BAMBOO);

    private VanillaWoodTypes() {
    }

    private static ResourceLocation mcLoc(String name) {
        return new ResourceLocation("minecraft", name);
    }

    public static Block getLog(WoodType woodType) {
        if (woodType == WoodType.BAMBOO) {
            return Blocks.STRIPPED_BAMBOO_BLOCK;
        }
        String suffix = VanillaWoodTypes.isNetherWood(woodType) ? "_stem" : "_log";
        return (Block)BuiltInRegistries.BLOCK.get(VanillaWoodTypes.mcLoc(woodType.name() + suffix));
    }

    public static Block getStrippedLog(WoodType woodType) {
        String suffix = VanillaWoodTypes.isNetherWood(woodType) ? "_stem" : "_log";
        return (Block)BuiltInRegistries.BLOCK.get(VanillaWoodTypes.mcLoc("stripped_" + woodType.name() + suffix));
    }

    public static Block getSlab(WoodType woodType) {
        return (Block)BuiltInRegistries.BLOCK.get(VanillaWoodTypes.mcLoc(woodType.name() + "_slab"));
    }

    public static Block getFence(WoodType woodType) {
        return (Block)BuiltInRegistries.BLOCK.get(VanillaWoodTypes.mcLoc(woodType.name() + "_fence"));
    }

    public static Block getPlanks(WoodType woodType) {
        return (Block)BuiltInRegistries.BLOCK.get(VanillaWoodTypes.mcLoc(woodType.name() + "_planks"));
    }

    public static boolean isNetherWood(WoodType woodType) {
        return woodType == WoodType.CRIMSON || woodType == WoodType.WARPED;
    }
}

