/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks.types;

import java.util.function.BiFunction;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;

public enum WoodDecorativeBlockTypes {
    BEAM("beam", BeamBlock::new),
    PALISADE("palisade", PalisadeBlock::new),
    SEAT("seat", SeatBlock::new),
    SUPPORT("support", SupportBlock::new);

    private final String name;
    private final BiFunction<WoodType, BlockBehaviour.Properties, IWoodenBlock> constructor;

    private WoodDecorativeBlockTypes(String name, BiFunction<WoodType, BlockBehaviour.Properties, IWoodenBlock> constructor) {
        this.name = name;
        this.constructor = constructor;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public IWoodenBlock create(WoodType woodType, BlockBehaviour.Properties properties) {
        return this.constructor.apply(woodType, properties);
    }
}

