/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.state.ModBlockProperties;
import lilypuree.decorative_blocks.blocks.state.SupportFaceShape;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;

public class BlockStateGenerationHelper {
    private String modid;
    private BlockStateProvider provider;

    public BlockStateGenerationHelper(String modid, BlockStateProvider provider) {
        this.modid = modid;
        this.provider = provider;
    }

    public void supportBlock(IWoodenBlock block) {
        WoodType woodType = block.getWoodType();
        String texture = woodType + "_support";
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        BlockStateProperties.UP.getAllValues().forEach(up -> {
            String upsideDown = (Boolean)up.value() != false ? "" : "upside_down_";
            ModBlockProperties.HORIZONTAL_SHAPE.getAllValues().forEach(shape -> {
                if (!((SupportFaceShape)((Object)((Object)((Object)shape.value())))).isHidden()) {
                    this.addFourDirections(builder, this.sideEndModel(woodType, WoodDecorativeBlockTypes.SUPPORT, upsideDown, "_horizontal_" + ((SupportFaceShape)((Object)((Object)((Object)shape.value())))).getSerializedName(), texture), (Property.Value)up, (Property.Value)shape);
                }
            });
            ModBlockProperties.VERTICAL_SHAPE.getAllValues().forEach(shape -> {
                if (!((SupportFaceShape)((Object)((Object)((Object)shape.value())))).isHidden()) {
                    this.addFourDirections(builder, this.sideEndModel(woodType, WoodDecorativeBlockTypes.SUPPORT, upsideDown, "_vertical_" + ((SupportFaceShape)((Object)((Object)((Object)shape.value())))).getSerializedName(), texture), (Property.Value)up, (Property.Value)shape);
                }
            });
            this.addFourDirections(builder, this.sideEndModel(woodType, WoodDecorativeBlockTypes.SUPPORT, upsideDown, "_post", texture), ModBlockProperties.HORIZONTAL_SHAPE.value((Comparable)((Object)SupportFaceShape.BIG)), ModBlockProperties.HORIZONTAL_SHAPE.value((Comparable)((Object)SupportFaceShape.SMALL)), ModBlockProperties.VERTICAL_SHAPE.value((Comparable)((Object)SupportFaceShape.BIG)), ModBlockProperties.VERTICAL_SHAPE.value((Comparable)((Object)SupportFaceShape.SMALL)), (Property.Value)up);
        });
        this.sideEndModel(woodType, WoodDecorativeBlockTypes.SUPPORT, "_inventory", texture);
        this.sideEndModel(woodType, WoodDecorativeBlockTypes.SUPPORT, "upside_down_", "_inventory", texture);
    }

    @SafeVarargs
    protected final MultiPartBlockStateBuilder addFourDirections(MultiPartBlockStateBuilder builder, ModelFile modelFile, Property.Value ... conditions) {
        this.addConditions(((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(modelFile).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.NORTH}), conditions).end();
        this.addConditions(((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(modelFile).rotationY(90).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.EAST}), conditions).end();
        this.addConditions(((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(modelFile).rotationY(180).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.SOUTH}), conditions).end();
        this.addConditions(((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(modelFile).rotationY(270).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.WEST}), conditions).end();
        return builder;
    }

    @SafeVarargs
    private final MultiPartBlockStateBuilder.PartBuilder addConditions(MultiPartBlockStateBuilder.PartBuilder builder, Property.Value ... conditions) {
        HashMap allConditions = new HashMap();
        for (Property.Value condition : conditions) {
            ArrayList<Comparable> sameConditions = new ArrayList<Comparable>();
            for (Property.Value valuePair : conditions) {
                if (condition.property() != valuePair.property()) continue;
                sameConditions.add(valuePair.value());
            }
            allConditions.put(condition.property(), sameConditions);
        }
        for (Map.Entry entry : allConditions.entrySet()) {
            builder.conditions.putAll((Object)((Property)entry.getKey()), (Iterable)entry.getValue());
        }
        return builder;
    }

    public void seatBlock(IWoodenBlock block) {
        WoodType woodType = block.getWoodType();
        String texture = woodType + "_seat";
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        this.addFourDirections(builder, this.simpleModel(woodType, WoodDecorativeBlockTypes.SEAT, "", texture), new Property.Value[0]);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.simpleModel(woodType, WoodDecorativeBlockTypes.SEAT, "_post", texture)).addModel()).condition((Property)BlockStateProperties.ATTACHED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.simpleModel(woodType, WoodDecorativeBlockTypes.SEAT, "_top_post", texture)).addModel()).condition((Property)ModBlockProperties.POST, (Comparable[])new Boolean[]{true});
        this.simpleModel(woodType, WoodDecorativeBlockTypes.SEAT, "_inventory", texture);
        this.simpleModel(woodType, WoodDecorativeBlockTypes.SEAT, "_post_inventory", texture);
    }

    public void beamBlock(IWoodenBlock block) {
        WoodType woodType = block.getWoodType();
        ModelFile beamXModel = this.beamModel(woodType, Direction.Axis.X);
        ModelFile beamYModel = this.beamModel(woodType, Direction.Axis.Y);
        ModelFile beamZModel = this.beamModel(woodType, Direction.Axis.Z);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile(beamXModel).addModel()).partialState().with((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile(beamYModel).addModel()).partialState().with((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile(beamZModel).addModel();
    }

    public ModelFile beamModel(WoodType wood, Direction.Axis axis) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.BEAM, "_" + axis.getName());
        return this.withSideEndTextures(builder, wood + "_beam");
    }

    public void palisadeBlock(IWoodenBlock block) {
        WoodType woodType = block.getWoodType();
        String texture = woodType + "_palisade";
        ModelFile postModel = this.sideEndModel(woodType, WoodDecorativeBlockTypes.PALISADE, "_post", texture);
        ModelFile sideModel = this.sideEndModel(woodType, WoodDecorativeBlockTypes.PALISADE, "_side", texture);
        ModelFile invModel = this.sideEndModel(woodType, WoodDecorativeBlockTypes.PALISADE, "_inventory", texture);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((PalisadeBlock)block)).part().modelFile(postModel).addModel()).end().part().modelFile(sideModel).uvLock(true).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(sideModel).uvLock(true).rotationY(180).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(sideModel).uvLock(true).rotationY(90).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(sideModel).uvLock(true).rotationY(270).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{Boolean.TRUE}).end();
    }

    private ModelFile sideEndModel(WoodType wood, WoodDecorativeBlockTypes blockType, String modelSuffix, String texture) {
        return this.withSideEndTextures(this.createModel(wood, blockType, modelSuffix), texture);
    }

    private ModelFile sideEndModel(WoodType wood, WoodDecorativeBlockTypes blockType, String modelPrefix, String modelSuffix, String texture) {
        return this.withSideEndTextures(this.createModel(wood, blockType, modelPrefix, modelSuffix), texture);
    }

    private ModelFile simpleModel(WoodType wood, WoodDecorativeBlockTypes blockType, String modelSuffix, String texture) {
        return this.withParticleTexture(this.createModel(wood, blockType, modelSuffix), texture);
    }

    private ModelBuilder<?> createModel(WoodType wood, WoodDecorativeBlockTypes type) {
        return this.createModel(wood, type, "");
    }

    private ModelBuilder<?> createModel(WoodType wood, WoodDecorativeBlockTypes type, String suffix) {
        return this.createModel(wood, type, "", suffix);
    }

    private ModelBuilder<?> createModel(WoodType wood, WoodDecorativeBlockTypes type, String prefix, String suffix) {
        String name = prefix + type + suffix;
        return ((BlockModelBuilder)this.models().getBuilder(wood.name() + "_" + name)).parent(this.modelFile(new ResourceLocation("decorative_blocks", "custom/" + name)));
    }

    public ModelBuilder<?> createChildModel(String path, String parent) {
        return ((BlockModelBuilder)this.models().getBuilder(path)).parent(this.modelFile(new ResourceLocation("decorative_blocks", "custom/" + parent)));
    }

    public ModelBuilder<?> withParticleTexture(ModelBuilder<?> model, String name) {
        ResourceLocation texture = this.modBlockLoc(name);
        return model.texture("particle", texture).texture("texture", texture);
    }

    public ModelBuilder<?> withSideEndTextures(ModelBuilder<?> model, String name) {
        ResourceLocation side = this.modBlockLoc(name + "_side");
        ResourceLocation end = this.modBlockLoc(name + "_end");
        return model.texture("particle", side).texture("side", side).texture("end", end);
    }

    private BlockModelProvider models() {
        return this.provider.models();
    }

    private MultiPartBlockStateBuilder getMultipartBuilder(Block b) {
        return this.provider.getMultipartBuilder(b);
    }

    private VariantBlockStateBuilder getVariantBuilder(Block b) {
        return this.provider.getVariantBuilder(b);
    }

    public ModelFile modelFile(ResourceLocation loc) {
        return new ModelFile.UncheckedModelFile(loc);
    }

    public ResourceLocation modBlockLoc(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }
}

