/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import java.util.concurrent.CompletableFuture;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.registration.BlockWrapper;
import lilypuree.decorative_blocks.registration.DBBlocks;
import lilypuree.decorative_blocks.registration.DBTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DBBlockTagsProvider
extends BlockTagsProvider {
    public DBBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "decorative_blocks", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (WoodType woodType : VanillaWoodTypes.VANILLA) {
            if (!VanillaWoodTypes.isNetherWood(woodType)) {
                if (woodType != WoodType.BAMBOO) {
                    this.tag(DBTags.Blocks.BEAMS_THAT_BURN).add(((BlockWrapper)DBBlocks.BEAMS.get((Object)woodType)).get());
                }
                this.tag(DBTags.Blocks.SEATS_THAT_BURN).add(((BlockWrapper)DBBlocks.SEATS.get((Object)woodType)).get());
                this.tag(DBTags.Blocks.PALISADES_THAT_BURN).add(((BlockWrapper)DBBlocks.PALISADES.get((Object)woodType)).get());
                this.tag(DBTags.Blocks.SUPPORTS_THAT_BURN).add(((BlockWrapper)DBBlocks.SUPPORTS.get((Object)woodType)).get());
                continue;
            }
            this.tag(DBTags.Blocks.BEAMS).add(((BlockWrapper)DBBlocks.BEAMS.get((Object)woodType)).get());
            this.tag(DBTags.Blocks.SEATS).add(((BlockWrapper)DBBlocks.SEATS.get((Object)woodType)).get());
            this.tag(DBTags.Blocks.PALISADES).add(((BlockWrapper)DBBlocks.PALISADES.get((Object)woodType)).get());
            this.tag(DBTags.Blocks.SUPPORTS).add(((BlockWrapper)DBBlocks.SUPPORTS.get((Object)woodType)).get());
        }
        this.tag(DBTags.Blocks.BEAMS).addTag(DBTags.Blocks.BEAMS_THAT_BURN);
        this.tag(DBTags.Blocks.SUPPORTS).addTag(DBTags.Blocks.SUPPORTS_THAT_BURN);
        this.tag(DBTags.Blocks.SEATS).addTag(DBTags.Blocks.SEATS_THAT_BURN);
        this.tag(DBTags.Blocks.PALISADES).addTag(DBTags.Blocks.PALISADES_THAT_BURN);
        this.tag(BlockTags.WALLS).addTag(DBTags.Blocks.PALISADES);
        this.tag(DBTags.Blocks.CHANDELIERS).add((Object[])new Block[]{DBBlocks.CHANDELIER.get(), DBBlocks.SOUL_CHANDELIER.get()});
    }
}

