/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import lilypuree.decorative_blocks.registration.DBBlocks;
import lilypuree.decorative_blocks.registration.DBItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DBItemModels
extends ItemModelProvider {
    public DBItemModels(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        ItemGenerationHelper helper = new ItemGenerationHelper("decorative_blocks", this);
        for (WoodType wood : VanillaWoodTypes.VANILLA) {
            if (wood != WoodType.BAMBOO) {
                ((ItemModelBuilder)this.getBuilder(wood + "_beam")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + wood + "_beam_y")));
            }
            ((ItemModelBuilder)this.getBuilder(wood + "_palisade")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + wood + "_palisade_inventory")));
            helper.seatModel(wood);
            helper.supportModel(wood);
        }
        helper.blockItem(DBBlocks.ROCKY_DIRT.get());
        helper.simpleItem((ItemLike)DBItems.CHAIN.get());
        helper.simpleItem((ItemLike)DBItems.BRAZIER.get());
        helper.simpleItem((ItemLike)DBItems.SOUL_BRAZIER.get());
    }

    public String getName() {
        return "Decorative Block Item Models";
    }

    public static class ItemGenerationHelper {
        private String modid;
        private ItemModelProvider provider;

        public ItemGenerationHelper(String modid, ItemModelProvider provider) {
            this.modid = modid;
            this.provider = provider;
        }

        private void blockItem(Block block) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
            ((ItemModelBuilder)this.provider.getBuilder(name)).parent(this.newModel(this.provider.modLoc("block/" + name)));
        }

        private void simpleItem(ItemLike item) {
            String name = BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
            this.generated(name, this.provider.modLoc("item/" + name));
        }

        public void simpleItem(ItemLike item, ResourceLocation texture) {
            String name = BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
            this.generated(name, texture);
        }

        public void generated(String path, ResourceLocation texture) {
            ((ItemModelBuilder)((ItemModelBuilder)this.provider.getBuilder(path)).parent(this.newModel(this.provider.mcLoc("item/generated")))).texture("layer0", texture);
        }

        public void supportModel(WoodType wood) {
            String name = wood.name() + "_support";
            ((ItemModelBuilder)((ItemModelBuilder)this.provider.getBuilder(name)).parent(this.newModel(name + "_inventory"))).override().model(this.newModel(wood.name() + "_upside_down_support_inventory")).predicate(SupportItem.OVERRIDE_TAG, 1.0f).end();
        }

        public void seatModel(WoodType wood) {
            String name = wood.name() + "_seat";
            ((ItemModelBuilder)((ItemModelBuilder)this.provider.getBuilder(name)).parent(this.newModel(name + "_inventory"))).override().model(this.newModel(name + "_post_inventory")).predicate(SeatItem.OVERRIDE_TAG, 1.0f).end();
        }

        public ModelFile newModel(String name) {
            return this.newModel(this.modBlockLoc(name));
        }

        public ModelFile newModel(ResourceLocation location) {
            return new ModelFile.UncheckedModelFile(location);
        }

        public ResourceLocation modBlockLoc(String name) {
            return new ResourceLocation(this.modid, "block/" + name);
        }
    }
}

