/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import java.util.concurrent.CompletableFuture;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.registration.DBBlocks;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.WoodType;

public class DBRecipes
extends RecipeProvider {
    public DBRecipes(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(pOutput, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        for (WoodType wood : VanillaWoodTypes.VANILLA) {
            DBRecipes.makeWoodenBlockRecipes(wood, recipeOutput);
        }
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, DBBlocks.BAR_PANEL, 2).pattern("##").define(Character.valueOf('#'), (ItemLike)Items.IRON_BARS), "has_ingot", new ItemLike[]{Items.IRON_INGOT});
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, DBBlocks.LATTICE, 1).pattern(" # ").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.STICK), "has_stick", new ItemLike[]{Items.STICK});
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, DBBlocks.ROCKY_DIRT, 1).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Items.DIRT), "has_dirt", new ItemLike[]{Items.DIRT});
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.DECORATIONS, DBBlocks.BRAZIER, 1).group("decorative_braziers").pattern("010").pattern(" 0 ").define(Character.valueOf('0'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('1'), ItemTags.COALS), "has_bar", new ItemLike[]{Items.IRON_BARS});
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.DECORATIONS, () -> DBBlocks.SOUL_BRAZIER.get().asItem(), 1).group("decorative_braziers").pattern(" 1 ").pattern("020").pattern(" 0 ").define(Character.valueOf('0'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('1'), ItemTags.COALS).define(Character.valueOf('2'), ItemTags.SOUL_FIRE_BASE_BLOCKS), "has_bar", new ItemLike[]{Items.IRON_BARS});
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)DBBlocks.STONE_PILLAR.get()).unlockedBy("has_stone", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STONE})).save(recipeOutput);
        DBRecipes.makeChandelierRecipeOf((ItemLike)DBBlocks.CHANDELIER.get(), Items.TORCH, recipeOutput);
        DBRecipes.makeChandelierRecipeOf((ItemLike)DBBlocks.SOUL_CHANDELIER.get(), Items.SOUL_TORCH, recipeOutput);
    }

    public static ShapedRecipeBuilder shapedRecipe(RecipeCategory category, ItemLike result, int count) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static ShapelessRecipeBuilder shapelessRecipe(RecipeCategory category, ItemLike result, int count) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static void addRecipe(RecipeOutput recipeOutput, RecipeBuilder builder, String criterion, ItemLike ... triggers) {
        DBRecipes.addRecipe(recipeOutput, RecipeBuilder.getDefaultRecipeId((ItemLike)builder.getResult()), builder, criterion, triggers);
    }

    public static void addRecipe(RecipeOutput recipeOutput, ResourceLocation name, RecipeBuilder builder, String criterion, ItemLike ... triggers) {
        builder.unlockedBy(criterion, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])triggers)).save(recipeOutput, name);
    }

    public static void makeWoodenBlockRecipes(WoodType woodType, RecipeOutput recipeOutput) {
        if (woodType != WoodType.BAMBOO) {
            DBRecipes.makeBeamRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.BEAM), recipeOutput);
        }
        DBRecipes.makePalisadeRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.PALISADE), recipeOutput);
        DBRecipes.makeSeatRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.SEAT), recipeOutput);
        DBRecipes.makeSupportRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.SUPPORT), recipeOutput);
    }

    public static IWoodenBlock getBlock(WoodType woodType, WoodDecorativeBlockTypes type) {
        return BuiltInRegistries.BLOCK.stream().filter(block -> {
            IWoodenBlock woodenBlock;
            if (block instanceof IWoodenBlock && (woodenBlock = (IWoodenBlock)block).getWoodType() == woodType) {
                switch (type) {
                    case BEAM: {
                        return block instanceof BeamBlock;
                    }
                    case PALISADE: {
                        return block instanceof PalisadeBlock;
                    }
                    case SEAT: {
                        return block instanceof SeatBlock;
                    }
                    case SUPPORT: {
                        return block instanceof SupportBlock;
                    }
                }
            }
            return false;
        }).findFirst().orElse(null);
    }

    public static void makeChandelierRecipeOf(ItemLike chandelier, Item torch, RecipeOutput recipeOutput) {
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.DECORATIONS, chandelier, 1).group("decorative_chandeliers").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)torch), "has_torch", new ItemLike[]{torch});
        String chandelierId = BuiltInRegistries.ITEM.getKey((Object)chandelier.asItem()).getPath();
        String torchId = BuiltInRegistries.ITEM.getKey((Object)torch).getPath();
        DBRecipes.addRecipe(recipeOutput, new ResourceLocation("decorative_blocks", torchId + "_from_" + chandelierId), (RecipeBuilder)DBRecipes.shapelessRecipe(RecipeCategory.DECORATIONS, (ItemLike)torch, 4).group("torches_from_chandeliers").requires(chandelier), "has_torch", new ItemLike[]{torch});
    }

    public static void makeBeamRecipeOf(IWoodenBlock block, RecipeOutput recipeOutput) {
        WoodType wood = block.getWoodType();
        Block strippedLog = VanillaWoodTypes.getStrippedLog(wood);
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 2).group("decorative_beams").pattern(" x ").pattern(" x ").define(Character.valueOf('x'), (ItemLike)strippedLog), "has_stripped_log", new ItemLike[]{strippedLog});
    }

    public static void makePalisadeRecipeOf(IWoodenBlock block, RecipeOutput recipeOutput) {
        WoodType wood = block.getWoodType();
        Block log = VanillaWoodTypes.getLog(wood);
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 6).group("decorative_palisades").pattern("xx ").define(Character.valueOf('x'), (ItemLike)log), "has_log", new ItemLike[]{log});
    }

    public static void makeSeatRecipeOf(IWoodenBlock block, RecipeOutput recipeOutput) {
        WoodType wood = block.getWoodType();
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 6).group("decorative_seats").pattern("x  ").pattern("y  ").define(Character.valueOf('x'), (ItemLike)VanillaWoodTypes.getSlab(wood)).define(Character.valueOf('y'), (ItemLike)VanillaWoodTypes.getFence(wood)), "has_plank", new ItemLike[]{VanillaWoodTypes.getPlanks(wood)});
    }

    public static void makeSupportRecipeOf(IWoodenBlock block, RecipeOutput recipeOutput) {
        WoodType wood = block.getWoodType();
        Block planks = VanillaWoodTypes.getLog(wood);
        DBRecipes.addRecipe(recipeOutput, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 6).group("decorative_supports").pattern("xx ").pattern("x  ").define(Character.valueOf('x'), (ItemLike)planks), "has_plank", new ItemLike[]{planks});
    }
}

