/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import java.util.concurrent.CompletableFuture;
import lilypuree.decorative_blocks.datagen.DBBlockStates;
import lilypuree.decorative_blocks.datagen.DBBlockTagsProvider;
import lilypuree.decorative_blocks.datagen.DBItemModels;
import lilypuree.decorative_blocks.datagen.DBItemTagsProvider;
import lilypuree.decorative_blocks.datagen.DBLootTables;
import lilypuree.decorative_blocks.datagen.DBRecipes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new DBRecipes(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DBLootTables(packOutput));
        DBBlockTagsProvider blockTagsProvider = new DBBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new DBItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DBBlockStates(packOutput, "decorative_blocks", existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DBItemModels(packOutput, "decorative_blocks", existingFileHelper));
    }
}

