/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.fluid;

import java.util.function.Supplier;
import lilypuree.decorative_blocks.fluid.ThatchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import org.jetbrains.annotations.Nullable;

public class ForgeThatchFluidBlock
extends LiquidBlock
implements ThatchBlock {
    public ForgeThatchFluidBlock(Supplier<FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof Player) {
            boolean isPlayerMoving;
            Player player = (Player)entityIn;
            boolean bl = isPlayerMoving = player.getDeltaMovement().length() > 0.1;
            if (worldIn.random.nextFloat() < 0.1f && isPlayerMoving) {
                worldIn.playSound(player, pos, SoundEvents.GRASS_HIT, SoundSource.BLOCKS, 0.8f, 1.5f);
            }
        }
    }

    public ItemStack pickupBlock(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.EMPTY;
    }
}

