/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.fluid;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public abstract class ThatchFluid
extends FlowingFluid {
    protected FluidReferenceHolder referenceHolder;

    public ThatchFluid(FluidReferenceHolder referenceHolder) {
        this.referenceHolder = referenceHolder;
    }

    public Fluid getFlowing() {
        return (Fluid)this.referenceHolder.flowing().get();
    }

    public Fluid getSource() {
        return (Fluid)this.referenceHolder.source().get();
    }

    public Item getBucket() {
        return Items.BUCKET;
    }

    public FluidReferenceHolder getReferenceHolder() {
        return this.referenceHolder;
    }

    protected void beforeDestroyingBlock(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
    }

    public int getSlopeFindDistance(LevelReader worldIn) {
        return 2;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)this.referenceHolder.liquidBlock.get().defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(ThatchFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn == this.getFlowing() || fluidIn == this.getSource();
    }

    public boolean isSource(FluidState fluidState) {
        return false;
    }

    public int getDropOff(LevelReader worldIn) {
        return 4;
    }

    public boolean canBeReplacedWith(FluidState p_215665_1_, BlockGetter p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return false;
    }

    public int getTickDelay(LevelReader level) {
        return 8;
    }

    protected boolean canConvertToSource(Level level) {
        return false;
    }

    protected void spreadTo(LevelAccessor worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
        if (direction == Direction.DOWN) {
            boolean shouldFlowInto = false;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos supportPos = pos.relative(dir);
                BlockState supportBlock = worldIn.getBlockState(supportPos);
                FluidState sourceFluid = worldIn.getFluidState(supportPos.above());
                if (!supportBlock.isFaceSturdy((BlockGetter)worldIn, supportPos, dir.getOpposite()) || sourceFluid.isEmpty()) continue;
                shouldFlowInto = true;
            }
            if (!shouldFlowInto) {
                return;
            }
        }
        if (blockStateIn.getBlock() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockStateIn.getBlock()).placeLiquid(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.isAir()) {
                this.beforeDestroyingBlock(worldIn, pos, blockStateIn);
            }
            worldIn.setBlock(pos, fluidStateIn.createLegacyBlock(), 3);
        }
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public record FluidReferenceHolder(Supplier<Block> sourceBlock, Supplier<LiquidBlock> liquidBlock, Supplier<FlowingFluid> flowing, Supplier<FlowingFluid> source, ResourceLocation thatchStillTexture, ResourceLocation thatchFlowingTexture, int color) {
        public Block getSourceBlock() {
            return this.sourceBlock.get();
        }

        public LiquidBlock getLiquidBlock() {
            return this.liquidBlock.get();
        }

        public FlowingFluid getFlowingFluid() {
            return this.flowing.get();
        }

        public FlowingFluid getSourceFluid() {
            return this.source.get();
        }
    }

    public static class Source
    extends ThatchFluid {
        public Source(FluidReferenceHolder referenceHolder) {
            super(referenceHolder);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
        }

        public int getAmount(FluidState p_207192_1_) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends ThatchFluid {
        public Flowing(FluidReferenceHolder referenceHolder) {
            super(referenceHolder);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        @Override
        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

