/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.items;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockstateCopyItem
extends Item {
    public static Map<Block, Set<Property<?>>> allowedProperties = new HashMap();

    public BlockstateCopyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        HolderLookup holderLookup = world.holderLookup(Registries.BLOCK);
        if (!world.isClientSide) {
            Player entity = context.getPlayer();
            ItemStack tool = context.getItemInHand();
            BlockPos pos = context.getClickedPos();
            BlockState existing = world.getBlockState(pos);
            if (entity.isShiftKeyDown()) {
                if (this.copyBlockState(tool, existing)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockState pasteResult = this.pasteTo((HolderLookup<Block>)holderLookup, existing, tool);
                if (pasteResult != null) {
                    world.setBlock(pos, pasteResult, 18);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private BlockState pasteTo(HolderLookup<Block> holderLookup, BlockState state, ItemStack tool) {
        CompoundTag tag = tool.getTagElement("blockstate");
        if (tag != null) {
            BlockState clipboard = NbtUtils.readBlockState(holderLookup, (CompoundTag)tag);
            if (state.getBlock() == clipboard.getBlock()) {
                for (Property<?> property : allowedProperties.get(state.getBlock())) {
                    state = (BlockState)state.setValue(property, clipboard.getValue(property));
                }
                return state;
            }
        }
        return null;
    }

    private boolean copyBlockState(ItemStack tool, BlockState state) {
        if (allowedProperties.containsKey(state.getBlock())) {
            CompoundTag nbt = tool.getOrCreateTag();
            nbt.put("blockstate", (Tag)NbtUtils.writeBlockState((BlockState)state));
            tool.setTag(nbt);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.hasShiftDown()) {
            CompoundTag tag = stack.getTagElement("blockstate");
            String blockstatename = "none";
            if (tag != null) {
                blockstatename = NbtUtils.readBlockState((HolderGetter)worldIn.holderLookup(Registries.BLOCK), (CompoundTag)tag).getBlock().getDescriptionId();
            }
            tooltip.add((Component)Component.translatable((String)"wiki.decorative_blocks.copy1"));
            tooltip.add((Component)Component.translatable((String)"wiki.decorative_blocks.copy2", (Object[])new Object[]{blockstatename}));
        }
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    public static void addProperties(Block block, Property<?> ... properties) {
        allowedProperties.put(block, (Set<Property<?>>)ImmutableSet.copyOf((Object[])properties));
    }

    static {
        BuiltInRegistries.BLOCK.forEach(block -> {
            if (block instanceof FenceBlock || block instanceof IronBarsBlock) {
                BlockstateCopyItem.addProperties(block, new Property[]{CrossCollisionBlock.NORTH, CrossCollisionBlock.EAST, CrossCollisionBlock.SOUTH, CrossCollisionBlock.WEST});
            } else if (block instanceof WallBlock) {
                allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)WallBlock.UP, (Object)WallBlock.EAST_WALL, (Object)WallBlock.NORTH_WALL, (Object)WallBlock.SOUTH_WALL, (Object)WallBlock.WEST_WALL));
            } else if (block instanceof StairBlock) {
                allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)StairBlock.SHAPE, (Object)StairBlock.FACING, (Object)StairBlock.HALF));
            } else if (!(block instanceof SlabBlock)) {
                if (block instanceof ComparatorBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)ComparatorBlock.MODE));
                } else if (block.getStateDefinition().getProperties().contains(BlockStateProperties.RAIL_SHAPE_STRAIGHT)) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)BlockStateProperties.RAIL_SHAPE_STRAIGHT));
                } else if (block instanceof DispenserBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)DispenserBlock.FACING));
                } else if (block instanceof GlazedTerracottaBlock || block instanceof RepeaterBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{HorizontalDirectionalBlock.FACING});
                } else if (block instanceof HugeMushroomBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)HugeMushroomBlock.UP, (Object)HugeMushroomBlock.EAST, (Object)HugeMushroomBlock.WEST, (Object)HugeMushroomBlock.DOWN, (Object)HugeMushroomBlock.NORTH, (Object)HugeMushroomBlock.SOUTH, (Object[])new Property[0]));
                } else if (block instanceof ObserverBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)DirectionalBlock.FACING));
                } else if (block.getStateDefinition().getProperties().contains(BlockStateProperties.RAIL_SHAPE)) {
                    BlockstateCopyItem.addProperties(block, new Property[]{BlockStateProperties.RAIL_SHAPE});
                } else if (block instanceof TrapDoorBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{BlockStateProperties.HORIZONTAL_FACING, TrapDoorBlock.HALF, TrapDoorBlock.OPEN});
                } else if (block instanceof RotatedPillarBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{RotatedPillarBlock.AXIS});
                } else if (block instanceof RedStoneWireBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{RedStoneWireBlock.EAST, RedStoneWireBlock.NORTH, RedStoneWireBlock.SOUTH, RedStoneWireBlock.WEST});
                }
            }
        });
    }
}

