/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.items;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SwitchableBlockItem<T extends Property<U>, U extends Comparable<U>>
extends BlockItem {
    private T switching;
    private int max;
    private String tagName;

    public SwitchableBlockItem(Block blockIn, Item.Properties builder, T switching, String tag) {
        super(blockIn, builder);
        this.switching = switching;
        this.max = switching.getPossibleValues().size() - 1;
        this.tagName = tag;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown()) {
            if (!worldIn.isClientSide()) {
                this.cycleValueTag(playerIn.getItemInHand(handIn));
            }
            return InteractionResultHolder.success((Object)playerIn.getItemInHand(handIn));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public BlockState getSwitchedState(BlockState state, ItemStack stack) {
        if (state != null && state.hasProperty(this.switching)) {
            state = (BlockState)state.setValue(this.switching, state.getBlock().defaultBlockState().getValue(this.switching));
            for (int i = 0; i < this.getValueTag(stack); ++i) {
                state = (BlockState)state.cycle(this.switching);
            }
        }
        return state;
    }

    private int getValueTag(ItemStack stack) {
        if (stack.hasTag()) {
            return stack.getTag().getInt(this.tagName);
        }
        return 0;
    }

    public ItemStack cycleValueTag(ItemStack stack) {
        int currentValue;
        CompoundTag tag = stack.getOrCreateTag();
        int n = currentValue = tag.contains(this.tagName, 3) ? tag.getInt(this.tagName) : 0;
        if (currentValue == this.max) {
            tag.remove(this.tagName);
            if (tag.isEmpty()) {
                stack.setTag(null);
            } else {
                stack.setTag(tag);
            }
            return stack;
        }
        tag.putInt(this.tagName, currentValue + 1);
        stack.setTag(tag);
        return stack;
    }

    public static void switchHeldItem(Player player) {
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof SwitchableBlockItem) {
            SwitchableBlockItem switchableBlockItem = (SwitchableBlockItem)item;
            player.setItemSlot(EquipmentSlot.MAINHAND, switchableBlockItem.cycleValueTag(stack));
        }
    }

    public String getTagName() {
        return this.tagName;
    }
}

