/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.items.BlockstateCopyItem;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockWrapper;
import lilypuree.decorative_blocks.registration.DBBlocks;
import lilypuree.decorative_blocks.registration.DBNames;
import lilypuree.decorative_blocks.registration.ItemWrapper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;

public class DBItems {
    public static final ItemWrapper<BlockItem> CHANDELIER = DBItems.registerBlockItem("chandelier", DBBlocks.CHANDELIER);
    public static final ItemWrapper<BlockItem> SOUL_CHANDELIER = DBItems.registerBlockItem("soul_chandelier", DBBlocks.SOUL_CHANDELIER);
    public static final ItemWrapper<BlockItem> BRAZIER = DBItems.registerBlockItem("brazier", DBBlocks.BRAZIER);
    public static final ItemWrapper<BlockItem> SOUL_BRAZIER = DBItems.registerBlockItem("soul_brazier", DBBlocks.SOUL_BRAZIER);
    public static final ItemWrapper<BlockItem> BAR_PANEL = DBItems.registerBlockItem("bar_panel", DBBlocks.BAR_PANEL);
    public static final ItemWrapper<BlockItem> LATTICE = DBItems.registerBlockItem("lattice", DBBlocks.LATTICE);
    public static final ItemWrapper<BlockItem> CHAIN = DBItems.registerBlockItem("chain", DBBlocks.CHAIN);
    public static final ItemWrapper<BlockItem> STONE_PILLAR = DBItems.registerBlockItem("stone_pillar", DBBlocks.STONE_PILLAR);
    public static final ItemWrapper<BlockItem> ROCKY_DIRT = DBItems.registerBlockItem("rocky_dirt", DBBlocks.ROCKY_DIRT);
    public static final ItemWrapper<Item> BLOCKSTATE_COPY_ITEM = DBItems.registerItem("blockstate_copy_item", () -> new BlockstateCopyItem(new Item.Properties().stacksTo(1)));
    public static final ImmutableMap<WoodType, ItemWrapper<BlockItem>> BEAM_ITEMBLOCKS;
    public static final ImmutableMap<WoodType, ItemWrapper<SeatItem>> SEAT_ITEMBLOCKS;
    public static final ImmutableMap<WoodType, ItemWrapper<SupportItem>> SUPPORT_ITEMBLOCKS;
    public static final ImmutableMap<WoodType, ItemWrapper<BlockItem>> PALISADE_ITEMBLOCKS;

    public static void init() {
    }

    private static <T extends Item> ItemWrapper<T> registerItem(String name, Supplier<T> itemSupplier) {
        return new ItemWrapper<T>(Services.PLATFORM.register(BuiltInRegistries.ITEM, name, itemSupplier));
    }

    private static ItemWrapper<BlockItem> registerBlockItem(String name, BlockWrapper<?> block) {
        return DBItems.registerItem(name, () -> new BlockItem(block.get(), new Item.Properties()));
    }

    static {
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (WoodType woodType : VanillaWoodTypes.VANILLA) {
            if (woodType != WoodType.BAMBOO) {
                beams.put((Object)woodType, DBItems.registerBlockItem(DBNames.name(woodType, WoodDecorativeBlockTypes.BEAM), (BlockWrapper)DBBlocks.BEAMS.get((Object)woodType)));
            }
            seats.put((Object)woodType, DBItems.registerItem(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> new SeatItem((Block)((BlockWrapper)DBBlocks.SEATS.get((Object)woodType)).get(), new Item.Properties())));
            supports.put((Object)woodType, DBItems.registerItem(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> new SupportItem((Block)((BlockWrapper)DBBlocks.SUPPORTS.get((Object)woodType)).get(), new Item.Properties())));
            palisades.put((Object)woodType, DBItems.registerBlockItem(DBNames.name(woodType, WoodDecorativeBlockTypes.PALISADE), (BlockWrapper)DBBlocks.PALISADES.get((Object)woodType)));
        }
        BEAM_ITEMBLOCKS = beams.build();
        PALISADE_ITEMBLOCKS = palisades.build();
        SUPPORT_ITEMBLOCKS = supports.build();
        SEAT_ITEMBLOCKS = seats.build();
    }
}

