/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.state.ModBlockProperties;
import lilypuree.decorative_blocks.blocks.state.SupportFaceShape;
import lilypuree.decorative_blocks.datagen.types.IWoodType;
import lilypuree.decorative_blocks.items.SwitchableBlockItem;
import net.minecraft.class_10;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4970;

public class SupportBlock
extends class_2383
implements class_3737,
IWoodenBlock {
    private static final double d0 = 3.0;
    private static final double d1 = 13.0;
    private static final double d2 = 4.0;
    private static final double d3 = 12.0;
    private static final class_265 TOP_LARGE = class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 TOP_SMALL_NS = class_2248.method_9541((double)4.0, (double)13.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final class_265 TOP_SMALL_EW = class_2248.method_9541((double)0.0, (double)13.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final class_265 BOTTOM_LARGE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final class_265 BOTTOM_SMALL_NS = class_2248.method_9541((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0);
    private static final class_265 BOTTOM_SMALL_EW = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0);
    private static final Map<class_2350, class_265> verticalLarge;
    private static final Map<class_2350, class_265> verticalSmall;
    public static final class_2746 WATERLOGGED;
    public static final class_2746 UP;
    public static final class_2754<SupportFaceShape> HORIZONTAL_SHAPE;
    public static final class_2754<SupportFaceShape> VERTICAL_SHAPE;
    private IWoodType woodType;
    private final ImmutableMap<class_2680, class_265> stateToShapeMap = SupportBlock.getStateToShapeMap((class_2689<class_2248, class_2680>)this.method_9595());

    public SupportBlock(class_4970.class_2251 properties, IWoodType woodType) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)UP, (Comparable)Boolean.TRUE)).method_11657(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.BIG))).method_11657(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL)));
        this.woodType = woodType;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return (class_265)this.stateToShapeMap.get((Object)state);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 ifluidstate = context.method_8045().method_8316(context.method_8037());
        boolean flag = ifluidstate.method_15767((class_3494)class_3486.field_15517) && ifluidstate.method_15761() == 8;
        class_2680 blockstate = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        class_1799 stack = context.method_8041();
        if (stack.method_7909() instanceof SwitchableBlockItem) {
            blockstate = ((SwitchableBlockItem)stack.method_7909()).getSwitchedState(blockstate, stack);
        }
        if (!((Boolean)blockstate.method_11654((class_2769)UP)).booleanValue()) {
            blockstate = (class_2680)blockstate.method_11657(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL));
        }
        return blockstate;
    }

    public static void onSupportActivation(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_243 hitPos) {
        boolean hitVertical;
        double hitHeight = hitPos.method_10214() - (double)pos.method_10264();
        if (((SupportFaceShape)((Object)state.method_11654(HORIZONTAL_SHAPE))).isHidden()) {
            hitVertical = true;
        } else if (((SupportFaceShape)((Object)state.method_11654(VERTICAL_SHAPE))).isHidden()) {
            hitVertical = false;
        } else if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            hitVertical = hitHeight < 0.8125;
        } else {
            boolean bl = hitVertical = hitHeight > 0.1875;
        }
        if (player.method_5715()) {
            if (hitVertical) {
                if (!((SupportFaceShape)((Object)state.method_11654(HORIZONTAL_SHAPE))).isHidden()) {
                    worldIn.method_8501(pos, (class_2680)state.method_11657(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.HIDDEN)));
                } else {
                    worldIn.method_8501(pos, (class_2680)state.method_11657(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.BIG)));
                }
            } else if (!((SupportFaceShape)((Object)state.method_11654(VERTICAL_SHAPE))).isHidden()) {
                worldIn.method_8501(pos, (class_2680)state.method_11657(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.HIDDEN)));
            } else {
                worldIn.method_8501(pos, (class_2680)state.method_11657(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL)));
            }
        } else if (hitVertical) {
            worldIn.method_8501(pos, (class_2680)state.method_11657(VERTICAL_SHAPE, (Comparable)((Object)((SupportFaceShape)((Object)state.method_11654(VERTICAL_SHAPE))).getSwitched())));
        } else {
            worldIn.method_8501(pos, (class_2680)state.method_11657(HORIZONTAL_SHAPE, (Comparable)((Object)((SupportFaceShape)((Object)state.method_11654(HORIZONTAL_SHAPE))).getSwitched())));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, WATERLOGGED, UP, HORIZONTAL_SHAPE, VERTICAL_SHAPE});
    }

    public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9516(class_2680 p_196266_1_, class_1922 p_196266_2_, class_2338 p_196266_3_, class_10 p_196266_4_) {
        return false;
    }

    private static ImmutableMap<class_2680, class_265> getStateToShapeMap(class_2689<class_2248, class_2680> stateManager) {
        Map map = stateManager.method_11662().stream().collect(Collectors.toMap(Function.identity(), SupportBlock::getShapeForState));
        return ImmutableMap.copyOf(map);
    }

    private static class_265 getShapeForState(class_2680 blockState) {
        boolean up = (Boolean)blockState.method_11654((class_2769)UP);
        class_2350 dir = (class_2350)blockState.method_11654((class_2769)field_11177);
        boolean ns = dir.method_10166() == class_2350.class_2351.field_11051;
        class_265 horizontal = class_259.method_1073();
        class_265 vertical = class_259.method_1073();
        switch ((SupportFaceShape)((Object)blockState.method_11654(HORIZONTAL_SHAPE))) {
            case BIG: {
                horizontal = up ? TOP_LARGE : BOTTOM_LARGE;
                break;
            }
            case SMALL: {
                horizontal = up ? (ns ? TOP_SMALL_NS : TOP_SMALL_EW) : (ns ? BOTTOM_SMALL_NS : BOTTOM_SMALL_EW);
            }
        }
        switch ((SupportFaceShape)((Object)blockState.method_11654(VERTICAL_SHAPE))) {
            case BIG: {
                vertical = verticalLarge.get(dir);
                break;
            }
            case SMALL: {
                vertical = verticalSmall.get(dir);
                break;
            }
            case HIDDEN: {
                if (horizontal != class_259.method_1073()) break;
                return class_259.method_1077();
            }
        }
        return class_259.method_1084((class_265)horizontal, (class_265)vertical);
    }

    static {
        WATERLOGGED = class_2741.field_12508;
        UP = class_2741.field_12519;
        HORIZONTAL_SHAPE = ModBlockProperties.HORIZONTAL_SHAPE;
        VERTICAL_SHAPE = ModBlockProperties.VERTICAL_SHAPE;
        verticalSmall = new EnumMap<class_2350, class_265>(class_2350.class);
        verticalLarge = new EnumMap<class_2350, class_265>(class_2350.class);
        class_2350.class_2353.field_11062.method_29716().forEach(dir -> {
            int x = dir.method_10148();
            int z = dir.method_10165();
            verticalLarge.put((class_2350)dir, class_2248.method_9541((double)((double)((1 - x * x) * 0) + (double)(x * x) * (6.5 - 6.5 * (double)x)), (double)0.0, (double)((double)((1 - z * z) * 0) + (double)(z * z) * (6.5 - 6.5 * (double)z)), (double)((double)((1 - x * x) * 16) + (double)(x * x) * (9.5 + -6.5 * (double)x)), (double)16.0, (double)((double)((1 - z * z) * 16) + (double)(z * z) * (9.5 + -6.5 * (double)z))));
            verticalSmall.put((class_2350)dir, class_2248.method_9541((double)((double)(1 - x * x) * 4.0 + (double)(x * x) * (6.5 - 6.5 * (double)x)), (double)0.0, (double)((double)(1 - z * z) * 4.0 + (double)(z * z) * (6.5 - 6.5 * (double)z)), (double)((double)(1 - x * x) * 12.0 + (double)(x * x) * (9.5 + -6.5 * (double)x)), (double)16.0, (double)((double)(1 - z * z) * 12.0 + (double)(z * z) * (9.5 + -6.5 * (double)z))));
        });
    }
}

