/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks;

import lilypuree.decorative_blocks.Config;
import lilypuree.decorative_blocks.Constants;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.core.DBItems;
import lilypuree.decorative_blocks.core.DBNames;
import lilypuree.decorative_blocks.core.DBTags;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.core.factory.BlockSuppliers;
import lilypuree.decorative_blocks.core.setup.ModSetup;
import lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import lilypuree.decorative_blocks.events.ClientEventHandler;
import lilypuree.decorative_blocks.fluid.ForgeThatchFluid;
import net.minecraft.network.protocol.Packet;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="decorative_blocks")
public class DecorativeBlocks {
    public DecorativeBlocks() {
        this.tagInit();
        Constants.ITEM_GROUP = new CreativeModeTab(-1, "decorative_blocks.general"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DBItems.BRAZIER);
            }
        };
        DummyEntityForSitting.factory = (type, level) -> new DummyEntityForSitting(type, level){

            public Packet<?> m_5654_() {
                return NetworkHooks.getEntitySpawningPacket((Entity)this);
            }
        };
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(e -> ModSetup.init());
        modBus.addListener(ClientEventHandler::initRenderLayers);
        modBus.addListener(ClientEventHandler::registerItemFunc);
        modBus.addListener(ClientEventHandler::onEntityRendererRegistry);
        modBus.addGenericListener(Block.class, this::registerBlocks);
        modBus.addGenericListener(Item.class, this::registerItems);
        modBus.addGenericListener(Fluid.class, this::registerFluids);
        modBus.addGenericListener(EntityType.class, this::registerEntities);
    }

    public void tagInit() {
        DBTags.Blocks.PALISADES = BlockTags.m_13116_((String)this.getName("palisades"));
        DBTags.Blocks.SUPPORTS = BlockTags.m_13116_((String)this.getName("supports"));
        DBTags.Blocks.SEATS = BlockTags.m_13116_((String)this.getName("seats"));
        DBTags.Blocks.BEAMS = BlockTags.m_13116_((String)this.getName("beams"));
        DBTags.Blocks.CHANDELIERS = BlockTags.m_13116_((String)this.getName("chandeliers"));
        DBTags.Blocks.BRAZIERS = BlockTags.m_13116_((String)this.getName("braziers"));
        DBTags.Blocks.BONFIRES = BlockTags.m_13116_((String)this.getName("bonfires"));
        DBTags.Items.PALISADES = ItemTags.m_13194_((String)this.getName("palisades"));
        DBTags.Items.SUPPORTS = ItemTags.m_13194_((String)this.getName("supports"));
        DBTags.Items.SEATS = ItemTags.m_13194_((String)this.getName("seats"));
        DBTags.Items.BEAMS = ItemTags.m_13194_((String)this.getName("beams"));
        DBTags.Items.CHANDELIERS = ItemTags.m_13194_((String)this.getName("chandeliers"));
        DBTags.Fluids.THATCH = FluidTags.m_13134_((String)this.getName("thatch"));
    }

    private String getName(String name) {
        return "decorative_blocks:" + name;
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        DBBlocks.init();
        if (Registration.STILL_THATCH == null) {
            Registration.STILL_THATCH = new ForgeThatchFluid.Source(Registration.referenceHolder);
            Registration.FLOWING_THATCH = new ForgeThatchFluid.Flowing(Registration.referenceHolder);
        }
        Registration.THATCH = BlockSuppliers.THATCH.get();
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Block[]{(Block)Registration.THATCH.setRegistryName(DBNames.THATCH), (Block)DBBlocks.ROCKY_DIRT.setRegistryName(DBNames.ROCKY_DIRT), (Block)DBBlocks.STONE_PILLAR.setRegistryName(DBNames.STONE_PILLAR), (Block)DBBlocks.CHAIN.setRegistryName(DBNames.CHAIN), (Block)DBBlocks.BAR_PANEL.setRegistryName(DBNames.BAR_PANEL), (Block)DBBlocks.LATTICE.setRegistryName(DBNames.LATTICE), (Block)DBBlocks.CHANDELIER.setRegistryName(DBNames.CHANDELIER), (Block)DBBlocks.SOUL_CHANDELIER.setRegistryName(DBNames.SOUL_CHANDELIER), (Block)DBBlocks.BONFIRE.setRegistryName(DBNames.BONFIRE), (Block)DBBlocks.SOUL_BONFIRE.setRegistryName(DBNames.SOUL_BONFIRE), (Block)DBBlocks.BRAZIER.setRegistryName(DBNames.BRAZIER), (Block)DBBlocks.SOUL_BRAZIER.setRegistryName(DBNames.SOUL_BRAZIER)});
        DBBlocks.BEAMS.forEach((wood, block) -> registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(wood + "_beam"))));
        DBBlocks.PALISADES.forEach((wood, block) -> registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(wood + "_palisade"))));
        DBBlocks.SUPPORTS.forEach((wood, block) -> registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(wood + "_support"))));
        DBBlocks.SEATS.forEach((wood, block) -> registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(wood + "_seat"))));
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        DBItems.init();
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{(Item)DBItems.ROCKY_DIRT.setRegistryName(DBNames.ROCKY_DIRT), (Item)DBItems.STONE_PILLAR.setRegistryName(DBNames.STONE_PILLAR), (Item)DBItems.CHAIN.setRegistryName(DBNames.CHAIN), (Item)DBItems.BAR_PANEL.setRegistryName(DBNames.BAR_PANEL), (Item)DBItems.BRAZIER.setRegistryName(DBNames.BRAZIER), (Item)DBItems.SOUL_BRAZIER.setRegistryName(DBNames.SOUL_BRAZIER), (Item)DBItems.LATTICE.setRegistryName(DBNames.LATTICE), (Item)DBItems.CHANDELIER.setRegistryName(DBNames.CHANDELIER), (Item)DBItems.SOUL_CHANDELIER.setRegistryName(DBNames.SOUL_CHANDELIER)});
        DBItems.BEAM_ITEMBLOCKS.forEach((wood, item) -> registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(wood + "_beam"))));
        DBItems.PALISADE_ITEMBLOCKS.forEach((wood, item) -> registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(wood + "_palisade"))));
        DBItems.SUPPORT_ITEMBLOCKS.forEach((wood, item) -> registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(wood + "_support"))));
        DBItems.SEAT_ITEMBLOCKS.forEach((wood, item) -> registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(wood + "_seat"))));
    }

    public void registerFluids(RegistryEvent.Register<Fluid> event) {
        if (Registration.STILL_THATCH == null) {
            Registration.STILL_THATCH = new ForgeThatchFluid.Source(Registration.referenceHolder);
            Registration.FLOWING_THATCH = new ForgeThatchFluid.Flowing(Registration.referenceHolder);
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Fluid[]{(Fluid)Registration.STILL_THATCH.setRegistryName(DBNames.STILL_THATCH), (Fluid)Registration.FLOWING_THATCH.setRegistryName(DBNames.FLOWING_THATCH)});
    }

    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        Registration.DUMMY_ENTITY_TYPE = (EntityType)EntityType.Builder.m_20704_(DummyEntityForSitting.factory, (MobCategory)MobCategory.MISC).m_20702_(256).m_20717_(20).m_20699_(1.0E-4f, 1.0E-4f).m_20712_("decorative_blocks:dummy").setRegistryName(DBNames.DUMMY_ENTITY);
        event.getRegistry().register((IForgeRegistryEntry)Registration.DUMMY_ENTITY_TYPE);
    }
}

