/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core.factory;

import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.BarPanelBlock;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChainBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.LatticeBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.PillarBlock;
import lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.datagen.types.IWoodType;
import lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.fluid.ThatchFluidBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class BlockSuppliers {
    public static final Material thatchMaterial = new Material.Builder(MaterialColor.f_76416_).m_76354_().m_76353_().m_76356_().m_76350_().m_76359_();
    public static final BlockBehaviour.Properties chainProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60978_(4.3f).m_60918_(SoundType.f_56743_).m_60955_();
    public static Supplier<Block> THATCH = () -> new ThatchFluidBlock(Registration.STILL_THATCH, BlockBehaviour.Properties.m_60939_((Material)thatchMaterial).m_60910_().m_60977_().m_60978_(100.0f).m_60993_());
    public static Supplier<Block> BONFIRE = () -> new BonfireBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76309_, (MaterialColor)MaterialColor.f_76402_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> 15).m_60993_());
    public static Supplier<Block> SOUL_BONFIRE = () -> new BonfireBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76309_, (MaterialColor)MaterialColor.f_76421_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> 14).m_60993_());
    public static Supplier<Block> CHANDELIER = () -> new ChandelierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 15), false);
    public static Supplier<Block> SOUL_CHANDELIER = () -> new ChandelierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 11), true);
    public static Supplier<Block> BRAZIER = () -> new BrazierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0).m_60955_(), false);
    public static Supplier<Block> SOUL_BRAZIER = () -> new BrazierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 10 : 0).m_60955_(), true);
    public static Supplier<Block> BAR_PANEL = () -> new BarPanelBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_());
    public static Supplier<Block> LATTICE = () -> new LatticeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(1.2f).m_60918_(SoundType.f_56736_).m_60955_());
    public static Supplier<Block> CHAIN = () -> new ChainBlock(chainProperties);
    public static Supplier<Block> STONE_PILLAR = () -> new PillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 6.5f));
    public static Supplier<Block> ROCKY_DIRT = () -> new RockyDirtBlock();

    public static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        BlockBehaviour.Properties woodProperty = BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).m_60978_(1.2f).m_60918_(wood.getSoundType());
        BlockBehaviour.Properties palisadeProperty = BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).m_60913_(2.0f, 4.0f).m_60918_(wood.getSoundType());
        switch (woodDecorativeBlockType) {
            default: {
                return new BeamBlock(woodProperty, wood);
            }
            case SEAT: {
                return new SeatBlock(woodProperty, wood);
            }
            case SUPPORT: {
                return new SupportBlock(woodProperty, wood);
            }
            case PALISADE: 
        }
        return new PalisadeBlock(palisadeProperty, wood);
    }
}

