/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import java.util.List;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.state.ModBlockProperties;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import lilypuree.decorative_blocks.items.SwitchableBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWoodenBlock {
    protected static final VoxelShape POST_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    protected static final VoxelShape TOP_POST = Block.m_49796_((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape JOIST_NS = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0);
    protected static final VoxelShape JOIST_EW = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)7.0, (double)16.0);
    protected static final VoxelShape SEAT_NS = Shapes.m_83110_((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_NS);
    protected static final VoxelShape SEAT_EW = Shapes.m_83110_((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_EW);
    protected static final VoxelShape JOIST_POST_NS = Shapes.m_83110_((VoxelShape)TOP_POST, (VoxelShape)JOIST_NS);
    protected static final VoxelShape JOIST_POST_EW = Shapes.m_83110_((VoxelShape)TOP_POST, (VoxelShape)JOIST_EW);
    protected static final VoxelShape SEAT_POST_NS = Shapes.m_83110_((VoxelShape)SEAT_NS, (VoxelShape)TOP_POST);
    protected static final VoxelShape SEAT_POST_EW = Shapes.m_83110_((VoxelShape)SEAT_EW, (VoxelShape)TOP_POST);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    public static final BooleanProperty POST = ModBlockProperties.POST;
    private IWoodType woodType;

    public SeatBlock(BlockBehaviour.Properties properties, IWoodType woodType) {
        super(properties);
        this.woodType = woodType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        boolean attached = (Boolean)state.m_61143_((Property)ATTACHED);
        boolean post = (Boolean)state.m_61143_((Property)POST);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                return attached ? (post ? SEAT_POST_NS : SEAT_NS) : (post ? JOIST_POST_NS : JOIST_NS);
            }
            case EAST: 
            case WEST: {
                return attached ? (post ? SEAT_POST_EW : SEAT_EW) : (post ? JOIST_POST_EW : JOIST_EW);
            }
        }
        return SEAT_NS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState ifluidstate = world.m_6425_(pos);
        ItemStack stack = context.m_43722_();
        boolean waterloggedFlag = ifluidstate.m_76153_((Tag)FluidTags.f_13131_) && ifluidstate.m_76186_() == 8;
        boolean attachedFlag = this.isInAttachablePos((LevelReader)world, pos);
        Direction facingDir = context.m_43719_();
        Direction placementDir = facingDir == Direction.DOWN || facingDir == Direction.UP ? context.m_8125_().m_122424_() : facingDir.m_122427_();
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)placementDir)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterloggedFlag))).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(attachedFlag));
        if (stack.m_41720_() instanceof SwitchableBlockItem) {
            blockstate = ((SwitchableBlockItem)stack.m_41720_()).getSwitchedState(blockstate, stack);
        }
        return blockstate;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(this.isInAttachablePos((LevelReader)worldIn, currentPos)));
        }
        return stateIn;
    }

    private boolean isInAttachablePos(LevelReader worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50681_) {
            return true;
        }
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, OCCUPIED, ATTACHED, POST});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean canAttachLantern;
        ItemStack heldItem = player.m_21120_(handIn);
        BlockState upperBlock = worldIn.m_8055_(pos.m_7494_());
        boolean canSit = hit.m_82434_() == Direction.UP && (Boolean)state.m_61143_((Property)OCCUPIED) == false && (Boolean)state.m_61143_((Property)POST) == false && heldItem.m_41619_() && upperBlock.m_60795_() && SeatBlock.isPlayerInRange(player, pos);
        Item item = heldItem.m_41720_();
        boolean isSeatAttachableItem = item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof LanternBlock;
        boolean bl = canAttachLantern = hit.m_82434_() == Direction.DOWN && isSeatAttachableItem && worldIn.m_8055_(pos.m_7495_()).m_60795_();
        if (!worldIn.m_5776_()) {
            if (canSit) {
                DummyEntityForSitting seat = (DummyEntityForSitting)Registration.DUMMY_ENTITY_TYPE.m_20615_(worldIn);
                seat.setSeatPos(pos);
                worldIn.m_7967_((Entity)seat);
                player.m_20329_((Entity)seat);
                return InteractionResult.SUCCESS;
            }
            if (canAttachLantern) {
                BlockState newState = (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.TRUE);
                worldIn.m_46597_(pos, newState);
                worldIn.m_7260_(pos, state, newState, 3);
                worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockItem)item).m_40614_().m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.TRUE), 16);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    private static boolean isPlayerInRange(Player player, BlockPos pos) {
        BlockPos playerPos = player.m_142538_();
        int blockReachDistance = 2;
        if (blockReachDistance == 0) {
            return playerPos.m_123342_() - pos.m_123342_() <= 1 && playerPos.m_123341_() - pos.m_123341_() == 0 && playerPos.m_123343_() - pos.m_123343_() == 0;
        }
        pos = pos.m_142022_(0.5, 0.5, 0.5);
        AABB range = new AABB((double)(pos.m_123341_() + blockReachDistance), (double)(pos.m_123342_() + blockReachDistance), (double)(pos.m_123343_() + blockReachDistance), (double)(pos.m_123341_() - blockReachDistance), (double)(pos.m_123342_() - blockReachDistance), (double)(pos.m_123343_() - blockReachDistance));
        return range.f_82288_ <= (double)(playerPos = playerPos.m_142022_(0.5, 0.5, 0.5)).m_123341_() && range.f_82289_ <= (double)playerPos.m_123342_() && range.f_82290_ <= (double)playerPos.m_123343_() && range.f_82291_ >= (double)playerPos.m_123341_() && range.f_82292_ >= (double)playerPos.m_123342_() && range.f_82293_ >= (double)playerPos.m_123343_();
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        List entities = worldIn.m_45976_(DummyEntityForSitting.class, new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0));
        for (DummyEntityForSitting entity : entities) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean m_7357_(BlockState p_196266_1_, BlockGetter p_196266_2_, BlockPos p_196266_3_, PathComputationType p_196266_4_) {
        return false;
    }
}

