/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.state.ModBlockProperties;
import lilypuree.decorative_blocks.blocks.state.SupportFaceShape;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.items.SwitchableBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SupportBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWoodenBlock {
    private static final double d0 = 3.0;
    private static final double d1 = 13.0;
    private static final double d2 = 4.0;
    private static final double d3 = 12.0;
    private static final VoxelShape TOP_LARGE = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_SMALL_NS = Block.m_49796_((double)4.0, (double)13.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_SMALL_EW = Block.m_49796_((double)0.0, (double)13.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape BOTTOM_LARGE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BOTTOM_SMALL_NS = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0);
    private static final VoxelShape BOTTOM_SMALL_EW = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0);
    private static final Map<Direction, VoxelShape> verticalLarge;
    private static final Map<Direction, VoxelShape> verticalSmall;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty UP;
    public static final EnumProperty<SupportFaceShape> HORIZONTAL_SHAPE;
    public static final EnumProperty<SupportFaceShape> VERTICAL_SHAPE;
    private IWoodType woodType;
    private final ImmutableMap<BlockState, VoxelShape> stateToShapeMap = SupportBlock.getStateToShapeMap((StateDefinition<Block, BlockState>)this.m_49965_());

    public SupportBlock(BlockBehaviour.Properties properties, IWoodType woodType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)UP, (Comparable)Boolean.TRUE)).m_61124_(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.BIG))).m_61124_(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL)));
        this.woodType = woodType;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.stateToShapeMap.get((Object)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = ifluidstate.m_76153_((Tag)FluidTags.f_13131_) && ifluidstate.m_76186_() == 8;
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        ItemStack stack = context.m_43722_();
        if (stack.m_41720_() instanceof SwitchableBlockItem) {
            blockstate = ((SwitchableBlockItem)stack.m_41720_()).getSwitchedState(blockstate, stack);
        }
        if (!((Boolean)blockstate.m_61143_((Property)UP)).booleanValue()) {
            blockstate = (BlockState)blockstate.m_61124_(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL));
        }
        return blockstate;
    }

    public static void onSupportActivation(BlockState state, Level worldIn, BlockPos pos, Player player, Vec3 hitPos) {
        boolean hitVertical;
        double hitHeight = hitPos.m_7098_() - (double)pos.m_123342_();
        if (((SupportFaceShape)((Object)state.m_61143_(HORIZONTAL_SHAPE))).isHidden()) {
            hitVertical = true;
        } else if (((SupportFaceShape)((Object)state.m_61143_(VERTICAL_SHAPE))).isHidden()) {
            hitVertical = false;
        } else if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            hitVertical = hitHeight < 0.8125;
        } else {
            boolean bl = hitVertical = hitHeight > 0.1875;
        }
        if (player.m_6144_()) {
            if (hitVertical) {
                if (!((SupportFaceShape)((Object)state.m_61143_(HORIZONTAL_SHAPE))).isHidden()) {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.HIDDEN)));
                } else {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.BIG)));
                }
            } else if (!((SupportFaceShape)((Object)state.m_61143_(VERTICAL_SHAPE))).isHidden()) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.HIDDEN)));
            } else {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL)));
            }
        } else if (hitVertical) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_(VERTICAL_SHAPE, (Comparable)((Object)((SupportFaceShape)((Object)state.m_61143_(VERTICAL_SHAPE))).getSwitched())));
        } else {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_(HORIZONTAL_SHAPE, (Comparable)((Object)((SupportFaceShape)((Object)state.m_61143_(HORIZONTAL_SHAPE))).getSwitched())));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, UP, HORIZONTAL_SHAPE, VERTICAL_SHAPE});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState p_196266_1_, BlockGetter p_196266_2_, BlockPos p_196266_3_, PathComputationType p_196266_4_) {
        return false;
    }

    private static ImmutableMap<BlockState, VoxelShape> getStateToShapeMap(StateDefinition<Block, BlockState> stateManager) {
        Map map = stateManager.m_61056_().stream().collect(Collectors.toMap(Function.identity(), SupportBlock::getShapeForState));
        return ImmutableMap.copyOf(map);
    }

    private static VoxelShape getShapeForState(BlockState blockState) {
        boolean up = (Boolean)blockState.m_61143_((Property)UP);
        Direction dir = (Direction)blockState.m_61143_((Property)f_54117_);
        boolean ns = dir.m_122434_() == Direction.Axis.Z;
        VoxelShape horizontal = Shapes.m_83040_();
        VoxelShape vertical = Shapes.m_83040_();
        switch ((SupportFaceShape)((Object)blockState.m_61143_(HORIZONTAL_SHAPE))) {
            case BIG: {
                horizontal = up ? TOP_LARGE : BOTTOM_LARGE;
                break;
            }
            case SMALL: {
                horizontal = up ? (ns ? TOP_SMALL_NS : TOP_SMALL_EW) : (ns ? BOTTOM_SMALL_NS : BOTTOM_SMALL_EW);
            }
        }
        switch ((SupportFaceShape)((Object)blockState.m_61143_(VERTICAL_SHAPE))) {
            case BIG: {
                vertical = verticalLarge.get(dir);
                break;
            }
            case SMALL: {
                vertical = verticalSmall.get(dir);
                break;
            }
            case HIDDEN: {
                if (horizontal != Shapes.m_83040_()) break;
                return Shapes.m_83144_();
            }
        }
        return Shapes.m_83110_((VoxelShape)horizontal, (VoxelShape)vertical);
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
        UP = BlockStateProperties.f_61366_;
        HORIZONTAL_SHAPE = ModBlockProperties.HORIZONTAL_SHAPE;
        VERTICAL_SHAPE = ModBlockProperties.VERTICAL_SHAPE;
        verticalSmall = new EnumMap<Direction, VoxelShape>(Direction.class);
        verticalLarge = new EnumMap<Direction, VoxelShape>(Direction.class);
        Direction.Plane.HORIZONTAL.m_122557_().forEach(dir -> {
            int x = dir.m_122429_();
            int z = dir.m_122431_();
            verticalLarge.put((Direction)dir, Block.m_49796_((double)((double)((1 - x * x) * 0) + (double)(x * x) * (6.5 - 6.5 * (double)x)), (double)0.0, (double)((double)((1 - z * z) * 0) + (double)(z * z) * (6.5 - 6.5 * (double)z)), (double)((double)((1 - x * x) * 16) + (double)(x * x) * (9.5 + -6.5 * (double)x)), (double)16.0, (double)((double)((1 - z * z) * 16) + (double)(z * z) * (9.5 + -6.5 * (double)z))));
            verticalSmall.put((Direction)dir, Block.m_49796_((double)((double)(1 - x * x) * 4.0 + (double)(x * x) * (6.5 - 6.5 * (double)x)), (double)0.0, (double)((double)(1 - z * z) * 4.0 + (double)(z * z) * (6.5 - 6.5 * (double)z)), (double)((double)(1 - x * x) * 12.0 + (double)(x * x) * (9.5 + -6.5 * (double)x)), (double)16.0, (double)((double)(1 - z * z) * 12.0 + (double)(z * z) * (9.5 + -6.5 * (double)z))));
        });
    }
}

