/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.fluid;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public abstract class ThatchFluid
extends FlowingFluid {
    protected FluidReferenceHolder referenceHolder;

    public ThatchFluid(FluidReferenceHolder referenceHolder) {
        this.referenceHolder = referenceHolder;
    }

    public Item m_6859_() {
        return Items.f_42446_;
    }

    public FluidReferenceHolder getReferenceHolder() {
        return this.referenceHolder;
    }

    public Fluid m_5615_() {
        return this.referenceHolder.getFlowingFluid();
    }

    public Fluid m_5613_() {
        return this.referenceHolder.getStillFluid();
    }

    public int m_6719_(LevelReader worldIn) {
        return 2;
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)this.referenceHolder.getFluidBlock().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(ThatchFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn == this.referenceHolder.getFlowingFluid() || fluidIn == this.referenceHolder.getStillFluid();
    }

    public int m_6713_(LevelReader worldIn) {
        return 4;
    }

    protected void m_7456_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
    }

    public boolean m_5486_(FluidState p_215665_1_, BlockGetter p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return false;
    }

    public int m_6718_(LevelReader level) {
        return 8;
    }

    protected boolean m_6760_() {
        return false;
    }

    protected void m_6364_(LevelAccessor worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
        if (direction == Direction.DOWN) {
            boolean shouldFlowInto = false;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos supportPos = pos.m_142300_(dir);
                BlockState supportBlock = worldIn.m_8055_(supportPos);
                FluidState sourceFluid = worldIn.m_6425_(supportPos.m_7494_());
                if (!supportBlock.m_60783_((BlockGetter)worldIn, supportPos, dir.m_122424_()) || sourceFluid.m_76178_()) continue;
                shouldFlowInto = true;
            }
            if (!shouldFlowInto) {
                return;
            }
        }
        if (blockStateIn.m_60734_() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockStateIn.m_60734_()).m_7361_(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.m_60795_()) {
                this.m_7456_(worldIn, pos, blockStateIn);
            }
            worldIn.m_7731_(pos, fluidStateIn.m_76188_(), 3);
        }
    }

    protected boolean m_6685_() {
        return true;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public static class FluidReferenceHolder {
        public Supplier<Block> sourceBlock;
        public ResourceLocation thatchStillTexture;
        public ResourceLocation thatchFlowingTexture;
        public Supplier<Fluid> flowingFluid;
        public Supplier<Fluid> stillFluid;
        public Supplier<Block> fluidBlock;
        public int color;

        public FluidReferenceHolder(Supplier<Block> sourceBlock, ResourceLocation thatchStillTexture, ResourceLocation thatchFlowingTexture, int color) {
            this.sourceBlock = sourceBlock;
            this.thatchStillTexture = thatchStillTexture;
            this.thatchFlowingTexture = thatchFlowingTexture;
            this.color = color;
        }

        public void setFlowingFluid(Supplier<Fluid> flowingFluid) {
            this.flowingFluid = flowingFluid;
        }

        public Fluid getFlowingFluid() {
            return this.flowingFluid.get();
        }

        public void setStillFluid(Supplier<Fluid> stillFluid) {
            this.stillFluid = stillFluid;
        }

        public Fluid getStillFluid() {
            return this.stillFluid.get();
        }

        public void setFluidBlock(Supplier<Block> fluidBlock) {
            this.fluidBlock = fluidBlock;
        }

        public Block getFluidBlock() {
            return this.fluidBlock.get();
        }

        public Block getSourceBlock() {
            return this.sourceBlock.get();
        }

        public int getColor() {
            return this.color;
        }
    }

    public static class Source
    extends ThatchFluid {
        public Source(FluidReferenceHolder referenceHolder) {
            super(referenceHolder);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
        }

        public int m_7430_(FluidState p_207192_1_) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends ThatchFluid {
        public Flowing(FluidReferenceHolder referenceHolder) {
            super(referenceHolder);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState fluidState) {
            return (Integer)fluidState.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

