/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class VineEntity
extends MobEntity
implements IMob {
    private LivingEntity caster;
    private UUID casterUuid;
    private int lifeTicks;
    private boolean isPerishable;

    protected VineEntity(EntityType<? extends VineEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected VineEntity(EntityType<? extends VineEntity> entityTypeIn, World worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        this(entityTypeIn, worldIn);
        this.func_70107_b(x, y, z);
        this.setCaster(casterIn);
        this.setLifeTicks(lifeTicksIn);
    }

    protected static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
        this.setLifeTicks(compound.func_74762_e("LifeTicks"));
        this.setPerishable(compound.func_74767_n("IsPerishable"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
        compound.func_74768_a("LifeTicks", this.getLifeTicks());
        compound.func_74757_a("IsPerishable", this.isPerishable());
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public boolean isPerishable() {
        return this.isPerishable;
    }

    public void setPerishable(boolean perishable) {
        this.isPerishable = perishable;
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public void setLifeTicks(int lifeTicksIn) {
        this.setPerishable(true);
        this.lifeTicks = lifeTicksIn;
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isPerishable && !this.field_70170_p.func_201670_d()) {
            --this.lifeTicks;
            if (this.lifeTicks <= 0) {
                this.func_70106_y();
            }
        }
    }

    public static boolean canVineSpawnInLight(EntityType<? extends VineEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && VineEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }
}

