/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.google.common.collect.Lists;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class IceCloudEntity
extends Entity {
    private int floatTicks = 60;
    public int fallTime = 0;
    private float fallHurtAmount = 3.0f;
    private LivingEntity caster;
    private UUID casterUuid;
    private LivingEntity target;
    private UUID targetUUID;
    private double heightAboveTarget = 2.0;
    private double heightAdjustment = (1.0f - this.func_213302_cg()) / 2.0f;

    public IceCloudEntity(World worldIn) {
        super((EntityType)ModEntityTypes.ICE_CLOUD.get(), worldIn);
    }

    public IceCloudEntity(EntityType<? extends IceCloudEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public IceCloudEntity(World worldIn, LivingEntity casterIn, LivingEntity targetIn) {
        this((EntityType<? extends IceCloudEntity>)((EntityType)ModEntityTypes.ICE_CLOUD.get()), worldIn);
        this.setCaster(casterIn);
        this.setTarget(targetIn);
        this.func_70107_b(casterIn.func_226277_ct_(), casterIn.func_226283_e_(1.0) + this.heightAboveTarget + this.heightAdjustment, casterIn.func_226281_cx_());
        this.field_70156_m = true;
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = targetIn.func_226277_ct_();
        this.field_70167_r = targetIn.func_226283_e_(1.0) + this.heightAboveTarget + this.heightAdjustment;
        this.field_70166_s = targetIn.func_226281_cx_();
    }

    protected void func_70088_a() {
    }

    private void tryToFloatAboveTarget(LivingEntity targetIn) {
        List nearbyIceClouds = this.field_70170_p.func_217394_a((EntityType)ModEntityTypes.ICE_CLOUD.get(), this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2), nearbyEntity -> nearbyEntity != this);
        if (nearbyIceClouds.isEmpty()) {
            this.func_70107_b(targetIn.func_226277_ct_(), targetIn.func_226283_e_(1.0) + this.heightAboveTarget + this.heightAdjustment, targetIn.func_226281_cx_());
        }
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
        this.targetUUID = target == null ? null : target.func_110124_au();
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && this.targetUUID != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.targetUUID)) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void func_70071_h_() {
        if (this.floatTicks > 0) {
            --this.floatTicks;
            if (this.target != null && !this.field_70170_p.field_72995_K) {
                this.tryToFloatAboveTarget(this.target);
            }
        } else {
            if (this.fallTime < 0 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            ++this.fallTime;
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.08, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                BlockPos iceCloudPosition = this.func_233580_cy_();
                if (!this.field_70122_E) {
                    if (!(this.field_70170_p.field_72995_K || (this.fallTime <= 100 || iceCloudPosition.func_177956_o() >= 1 && iceCloudPosition.func_177956_o() <= 256) && this.fallTime <= 600)) {
                        this.func_70106_y();
                    }
                } else {
                    BlockState blockstate = this.field_70170_p.func_180495_p(iceCloudPosition);
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (!blockstate.func_203425_a(Blocks.field_196603_bb)) {
                        this.spawnIceExplosionCloud();
                        this.func_70106_y();
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    public void spawnIceExplosionCloud() {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197627_t);
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184486_b(0);
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        int distanceFallen = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (distanceFallen > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.damage(livingEntity, distanceFallen);
            }
        }
        return false;
    }

    private void damage(LivingEntity targetEntity, int distanceFallen) {
        LivingEntity caster = this.getCaster();
        IndirectEntityDamageSource summonedFallingBlockDamageSource = new IndirectEntityDamageSource("iceCloud", (Entity)this, (Entity)caster);
        float damageAmount = MathHelper.func_76141_d((float)((float)distanceFallen * this.fallHurtAmount));
        if (targetEntity.func_70089_S() && !targetEntity.func_190530_aW() && targetEntity != caster) {
            if (caster == null) {
                targetEntity.func_70097_a((DamageSource)summonedFallingBlockDamageSource, damageAmount);
            } else {
                if (caster.func_184191_r((Entity)targetEntity)) {
                    return;
                }
                targetEntity.func_70097_a((DamageSource)summonedFallingBlockDamageSource, damageAmount);
                targetEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 4));
            }
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.fallTime = compound.func_74762_e("Time");
        this.fallHurtAmount = compound.func_74760_g("FallHurtAmount");
        this.setFloatTicks(compound.func_74762_e("FloatTicks"));
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
        if (compound.func_186855_b("Target")) {
            this.casterUuid = compound.func_186857_a("Target");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74776_a("FallHurtAmount", this.fallHurtAmount);
        compound.func_74768_a("FloatTicks", this.getFloatTicks());
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
        if (this.targetUUID != null) {
            compound.func_186854_a("Target", this.targetUUID);
        }
    }

    public int getFloatTicks() {
        return this.floatTicks;
    }

    public void setFloatTicks(int floatTicksIn) {
        this.floatTicks = floatTicksIn;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }
}

