/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.goals.switchcombat.SwitchCombatItemGoal;
import com.infamous.dungeons_mobs.goals.switchcombat.ThrowAndMeleeAttackGoal;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class FrozenZombieEntity
extends ZombieEntity
implements IRangedAttackMob {
    public FrozenZombieEntity(World worldIn) {
        super(worldIn);
    }

    public FrozenZombieEntity(EntityType<? extends FrozenZombieEntity> p_i48549_1_, World p_i48549_2_) {
        super(p_i48549_1_, p_i48549_2_);
    }

    public static boolean canFrozenZombieSpawn(EntityType<FrozenZombieEntity> entityType, IServerWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random rand) {
        return FrozenZombieEntity.func_223325_c(entityType, (IServerWorld)iWorld, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == SpawnReason.SPAWNER || iWorld.func_226660_f_(blockPos));
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, (Goal)new FrozenZombieAttackGoal(this, 1.0, 20, 15.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new SwitchCombatItemGoal((MobEntity)this, 6.0, 6.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 1.0, true, 4, () -> ((FrozenZombieEntity)this).func_146072_bX()));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{ZombifiedPiglinEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ZombieEntity.func_234342_eQ_();
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        super.func_180481_a(difficultyInstance);
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_151126_ay));
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.SNOWFLAKE.get(), this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity targetEntity) {
        if (super.func_70652_k(targetEntity)) {
            if (targetEntity instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 4;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 8;
                }
                if (i > 0) {
                    ((LivingEntity)targetEntity).func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_82196_d(LivingEntity livingEntity, float v) {
        SnowballEntity snowballentity = new SnowballEntity(this.field_70170_p, (LivingEntity)this);
        double adjustedEyeY = livingEntity.func_226280_cw_() - (double)1.1f;
        double xDifference = livingEntity.func_226277_ct_() - this.func_226277_ct_();
        double yDifference = adjustedEyeY - snowballentity.func_226278_cu_();
        double zDifference = livingEntity.func_226281_cx_() - this.func_226281_cx_();
        float adjustedHorizontalDistance = MathHelper.func_76133_a((double)(xDifference * xDifference + zDifference * zDifference)) * 0.2f;
        snowballentity.func_70186_c(xDifference, yDifference + (double)adjustedHorizontalDistance, zDifference, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 0.4f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)snowballentity);
    }

    static class FrozenZombieAttackGoal
    extends ThrowAndMeleeAttackGoal {
        private final FrozenZombieEntity zombie;
        private int raiseArmTicks;

        FrozenZombieAttackGoal(FrozenZombieEntity zombieEntity, double speedAmplifier, int attackInterval, float maxDistance, boolean useLongMemory) {
            super(zombieEntity, speedAmplifier, attackInterval, maxDistance, useLongMemory);
            this.zombie = zombieEntity;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.raiseArmTicks = 0;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.zombie.func_213395_q(false);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            ++this.raiseArmTicks;
            if (this.raiseArmTicks >= 5 && this.func_234041_j_() < this.func_234042_k_() / 2) {
                this.zombie.func_213395_q(true);
            } else {
                this.zombie.func_213395_q(false);
            }
        }
    }
}

