/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IllusionerEntity.class})
public abstract class IllusionerEntityMixin
extends SpellcastingIllagerEntity
implements IRangedAttackMob {
    private Vector3d[] emptyRenderLocation = new Vector3d[0];

    protected IllusionerEntityMixin(EntityType<? extends SpellcastingIllagerEntity> type, World world) {
        super(type, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="HEAD")}, method={"getRenderLocations"}, cancellable=true)
    private void getRenderLocations(float partialTicks, CallbackInfoReturnable<Vector3d[]> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)this.emptyRenderLocation);
    }

    @Inject(at={@At(value="HEAD")}, method={"attackEntityWithRangedAttack"}, cancellable=true)
    private void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor, CallbackInfo callbackInfo) {
        ItemStack fireworkRocket = IllusionerEntityMixin.createPinkRocket();
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, fireworkRocket, (Entity)this, this.func_226277_ct_(), this.func_226280_cw_() - (double)0.15f, this.func_226281_cx_(), true);
        double xDifference = target.func_226277_ct_() - this.func_226277_ct_();
        double yDifference = target.func_226283_e_(0.3333333333333333) - fireworkrocketentity.func_226278_cu_();
        double zDifference = target.func_226281_cx_() - this.func_226281_cx_();
        double horizontalDifference = MathHelper.func_76133_a((double)(xDifference * xDifference + zDifference * zDifference));
        fireworkrocketentity.func_70186_c(xDifference, yDifference + horizontalDifference * (double)0.2f, zDifference, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
        callbackInfo.cancel();
    }

    private static ItemStack createPinkRocket() {
        ItemStack rocket = new ItemStack((IItemProvider)Items.field_196152_dE);
        ItemStack star = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT starExplosionNBT = star.func_190925_c("Explosion");
        starExplosionNBT.func_74768_a("Type", FireworkRocketItem.Shape.BURST.func_196071_a());
        CompoundNBT rocketFireworksNBT = rocket.func_190925_c("Fireworks");
        ListNBT rocketExplosionsNBT = new ListNBT();
        CompoundNBT actualStarExplosionNBT = star.func_179543_a("Explosion");
        if (actualStarExplosionNBT != null) {
            ArrayList colorList = Lists.newArrayList();
            int pinkFireworkColor = DyeColor.PINK.func_196060_f();
            colorList.add(pinkFireworkColor);
            actualStarExplosionNBT.func_197646_b("Colors", (List)colorList);
            actualStarExplosionNBT.func_197646_b("FadeColors", (List)colorList);
            rocketExplosionsNBT.add((Object)actualStarExplosionNBT);
        }
        if (!rocketExplosionsNBT.isEmpty()) {
            rocketFireworksNBT.func_218657_a("Explosions", (INBT)rocketExplosionsNBT);
        }
        return rocket;
    }
}

