/*
 * Decompiled with CFR 0.152.
 */
package net.entityoutliner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import net.entityoutliner.EntityListWidget;
import net.entityoutliner.EntityOutliner;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.StringUtils;

public class EntitySelector
extends class_437 {
    private class_342 searchField;
    private EntityListWidget list;
    public static boolean groupByCategory = true;
    private static String searchText = "";
    public static Hashtable<String, List<class_1299<?>>> searcher;
    public static HashSet<class_1299<?>> outlinedEntityTypes;

    protected EntitySelector(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        int buttonInterval;
        this.field_22787.field_1774.method_1462(true);
        if (searcher == null) {
            this.initializePrefixTree();
        }
        this.list = new EntityListWidget(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25, this::onCheckboxToggled);
        this.field_22786.add(this.list);
        this.searchField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 6, 200, 20, class_2561.method_30163((String)searchText));
        this.searchField.method_1852(searchText);
        this.searchField.method_1863(this::onSearchFieldUpdate);
        this.field_22786.add(this.searchField);
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonOffset = buttonInterval = (this.field_22789 - 4 * buttonWidth) / 5;
        int buttonY = this.field_22790 - 16 - buttonHeight / 2;
        this.method_25411((class_339)new class_4185(buttonOffset, buttonY, buttonWidth, buttonHeight, (class_2561)new class_2588(groupByCategory ? "button.entity-outliner.categories" : "button.entity-outliner.no-categories"), button -> {
            groupByCategory = !groupByCategory;
            this.onSearchFieldUpdate(this.searchField.method_1882());
            button.method_25355((class_2561)new class_2588(groupByCategory ? "button.entity-outliner.categories" : "button.entity-outliner.no-categories"));
        }));
        this.method_25411((class_339)new class_4185(buttonOffset + (buttonWidth + buttonInterval), buttonY, buttonWidth, buttonHeight, (class_2561)new class_2588("button.entity-outliner.deselect"), button -> {
            outlinedEntityTypes.clear();
            this.onSearchFieldUpdate(this.searchField.method_1882());
        }));
        this.method_25411((class_339)new class_4185(buttonOffset + (buttonWidth + buttonInterval) * 2, buttonY, buttonWidth, buttonHeight, (class_2561)new class_2588(EntityOutliner.outliningEntities ? "button.entity-outliner.on" : "button.entity-outliner.off"), button -> {
            EntityOutliner.outliningEntities = !EntityOutliner.outliningEntities;
            button.method_25355((class_2561)new class_2588(EntityOutliner.outliningEntities ? "button.entity-outliner.on" : "button.entity-outliner.off"));
        }));
        this.method_25411((class_339)new class_4185(buttonOffset + (buttonWidth + buttonInterval) * 3, buttonY, buttonWidth, buttonHeight, (class_2561)new class_2588("button.entity-outliner.done"), button -> this.field_22787.method_1507(null)));
        this.method_20085((class_364)this.searchField);
        this.onSearchFieldUpdate(this.searchField.method_1882());
    }

    private void initializePrefixTree() {
        searcher = new Hashtable();
        ArrayList<class_1299> allResults = new ArrayList<class_1299>();
        searcher.put("", allResults);
        ArrayList<class_1299> entityTypes = new ArrayList<class_1299>();
        for (class_1299 entityType : class_2378.field_11145) {
            entityTypes.add(entityType);
        }
        entityTypes.sort(new Comparator<class_1299<?>>(){

            @Override
            public int compare(class_1299<?> o1, class_1299<?> o2) {
                return o1.method_5897().method_10851().compareTo(o2.method_5897().method_10851());
            }
        });
        for (class_1299 entityType : entityTypes) {
            String name = entityType.method_5897().getString().toLowerCase();
            allResults.add(entityType);
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add("");
            for (int i = 0; i < name.length(); ++i) {
                char character = name.charAt(i);
                for (int p = 0; p < prefixes.size(); ++p) {
                    List<Object> results;
                    String prefix = (String)prefixes.get(p) + character;
                    prefixes.set(p, prefix);
                    if (searcher.containsKey(prefix)) {
                        results = searcher.get(prefix);
                    } else {
                        results = new ArrayList();
                        searcher.put(prefix, results);
                    }
                    results.add(entityType);
                }
                if (!Character.isWhitespace(character)) continue;
                prefixes.add("");
            }
        }
    }

    private void onCheckboxToggled(class_1299<?> entityType, boolean checked) {
        if (!checked && outlinedEntityTypes.contains(entityType)) {
            outlinedEntityTypes.remove(entityType);
        } else if (checked && !outlinedEntityTypes.contains(entityType)) {
            outlinedEntityTypes.add(entityType);
        }
    }

    private String getCategoryName(class_1311 category) {
        String name = "";
        for (String term : category.method_6133().trim().split("\\p{Punct}|\\p{Space}")) {
            name = name + StringUtils.capitalize((String)term) + " ";
        }
        return name.trim();
    }

    private void onSearchFieldUpdate(String text) {
        searchText = text;
        text = text.toLowerCase().trim();
        this.list.clearListEntries();
        if (searcher.containsKey(text)) {
            List<class_1299<?>> results = searcher.get(text);
            if (groupByCategory) {
                Hashtable resultsByCategory = new Hashtable();
                for (class_1299<?> entityType : results) {
                    class_1311 category = entityType.method_5891();
                    if (!resultsByCategory.containsKey(category)) {
                        resultsByCategory.put(category, new ArrayList());
                    }
                    ((List)resultsByCategory.get(category)).add(entityType);
                }
                for (class_1311 category : class_1311.values()) {
                    if (!resultsByCategory.containsKey(category)) continue;
                    this.list.addListEntry(EntityListWidget.HeaderEntry.create(this.field_22787.field_1772, this.getCategoryName(category), this.field_22789, 25));
                    for (class_1299 entityType : (List)resultsByCategory.get(category)) {
                        this.list.addListEntry(EntityListWidget.CheckboxEntry.create(entityType, outlinedEntityTypes.contains(entityType), this.field_22789));
                    }
                }
            } else {
                for (class_1299<?> entityType : results) {
                    this.list.addListEntry(EntityListWidget.CheckboxEntry.create(entityType, outlinedEntityTypes.contains(entityType), this.field_22789));
                }
            }
        } else {
            this.list.addListEntry(EntityListWidget.HeaderEntry.create(this.field_22787.field_1772, "No results", this.field_22789, 25));
        }
        this.list.method_25307(this.list.method_25341());
    }

    public void method_25432() {
        this.field_22787.field_1774.method_1462(false);
    }

    public void method_25393() {
        this.searchField.method_1865();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        this.method_25395((class_364)this.searchField);
        this.searchField.method_1876(true);
        this.searchField.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.list.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    static {
        outlinedEntityTypes = new HashSet();
    }
}

