/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation;

import com.epicfight.animation.Pose;
import com.epicfight.animation.types.DynamicAnimation;
import com.epicfight.capabilities.entity.EntitydataLiving;

public class AnimationPlayer {
    protected float elapsedTime;
    private float prevElapsedTime;
    private float exceedTime;
    private boolean isEnd;
    private DynamicAnimation play;

    public AnimationPlayer() {
        this.resetPlayer();
    }

    public AnimationPlayer(DynamicAnimation animation) {
        this.setPlayAnimation(animation);
    }

    public void update(float updateTime) {
        this.prevElapsedTime = this.elapsedTime;
        this.elapsedTime += updateTime;
        if (this.elapsedTime >= this.play.getTotalTime()) {
            if (this.play.isRepeat()) {
                this.prevElapsedTime = 0.0f;
                this.elapsedTime %= this.play.getTotalTime();
            } else {
                this.exceedTime = this.elapsedTime % this.play.getTotalTime();
                this.elapsedTime = this.play.getTotalTime();
                this.isEnd = true;
            }
        } else if (this.elapsedTime < 0.0f) {
            if (this.play.isRepeat()) {
                this.prevElapsedTime = this.play.getTotalTime();
                this.elapsedTime = this.play.getTotalTime() + this.elapsedTime;
            } else {
                this.elapsedTime = 0.0f;
                this.isEnd = true;
            }
        }
    }

    public void synchronize(AnimationPlayer animationPlayer) {
        this.play = animationPlayer.play;
        this.elapsedTime = animationPlayer.elapsedTime;
        this.prevElapsedTime = animationPlayer.prevElapsedTime;
        this.exceedTime = animationPlayer.exceedTime;
        this.isEnd = animationPlayer.isEnd;
    }

    public void resetPlayer() {
        this.elapsedTime = 0.0f;
        this.prevElapsedTime = 0.0f;
        this.exceedTime = 0.0f;
        this.isEnd = false;
    }

    public void setPlayAnimation(DynamicAnimation animation) {
        this.resetPlayer();
        this.play = animation;
    }

    public void setEmpty() {
        this.resetPlayer();
        this.play = null;
    }

    public Pose getCurrentPose(EntitydataLiving entitydata, float interpolation) {
        return this.play.getPoseByTime(entitydata, this.prevElapsedTime + (this.elapsedTime - this.prevElapsedTime) * interpolation);
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(float elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public DynamicAnimation getPlay() {
        return this.play;
    }

    public float getExceedTime() {
        return this.exceedTime;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public boolean isEmpty() {
        return this.play == null;
    }
}

