/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation;

import com.epicfight.utils.math.Mat4f;
import java.util.ArrayList;
import java.util.List;

public class Joint {
    private final List<Joint> subJoints = new ArrayList<Joint>();
    private final int jointId;
    private final String jointName;
    private final Mat4f localTransform;
    private Mat4f inversedTransform = new Mat4f();
    private Mat4f animatedTransform = new Mat4f();

    public Joint(String name, int jointID, Mat4f localTransform) {
        this.jointId = jointID;
        this.jointName = name;
        this.localTransform = localTransform;
    }

    public void addSubJoint(Joint ... joints) {
        for (Joint joint : joints) {
            this.subJoints.add(joint);
        }
    }

    public void setAnimatedTransform(Mat4f animatedTransform) {
        this.animatedTransform = animatedTransform;
    }

    public void initializeAnimationTransform() {
        this.animatedTransform.setIdentity();
        for (Joint joint : this.subJoints) {
            joint.initializeAnimationTransform();
        }
    }

    public void setInversedModelTransform(Mat4f superTransform) {
        Mat4f modelTransform = Mat4f.mul(superTransform, this.localTransform, null);
        Mat4f.invert(modelTransform, this.inversedTransform);
        for (Joint joint : this.subJoints) {
            joint.setInversedModelTransform(modelTransform);
        }
    }

    public Mat4f getLocalTrasnform() {
        return this.localTransform;
    }

    public Mat4f getAnimatedTransform() {
        return this.animatedTransform;
    }

    public Mat4f getInversedModelTransform() {
        return this.inversedTransform;
    }

    public List<Joint> getSubJoints() {
        return this.subJoints;
    }

    public String getName() {
        return this.jointName;
    }

    public int getId() {
        return this.jointId;
    }
}

