/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation;

import com.epicfight.animation.Quaternion;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;

public class JointTransform {
    public static final JointTransform defaultTransform = new JointTransform(new Vec3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, 1.0f));
    private Vec3f position;
    public Quaternion rotation;

    public JointTransform(Vec3f position, Quaternion rotation) {
        this.position = position;
        this.rotation = rotation;
    }

    public Vec3f getPosition() {
        return this.position;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public Mat4f toTransformMatrix() {
        Mat4f matrix = new Mat4f();
        matrix.translate(this.position);
        Mat4f.mul(matrix, this.rotation.toRotationMatrix(), matrix);
        return matrix;
    }

    public static JointTransform interpolate(JointTransform prev, JointTransform next, float progression) {
        Vec3f pos = JointTransform.interpolate(prev.position, next.position, progression);
        Quaternion rot = Quaternion.interpolate(prev.rotation, next.rotation, progression);
        return new JointTransform(pos, rot);
    }

    private static Vec3f interpolate(Vec3f start, Vec3f end, float progression) {
        float x = start.x + (end.x - start.x) * progression;
        float y = start.y + (end.y - start.y) * progression;
        float z = start.z + (end.z - start.z) * progression;
        return new Vec3f(x, y, z);
    }
}

