/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types;

import com.epicfight.animation.JointTransform;
import com.epicfight.animation.Pose;
import com.epicfight.animation.Quaternion;
import com.epicfight.animation.TransformSheet;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.collada.AnimationDataExtractor;
import com.epicfight.main.ModCore;
import com.epicfight.model.Armature;
import com.epicfight.utils.math.Vec3f;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class AimingAnimation
extends StaticAnimation<EntitydataFighter> {
    public StaticAnimation lookUp;
    public StaticAnimation lookDown;

    public AimingAnimation(int id, float convertTime, boolean repeatPlay, String path1, String path2, String path3) {
        super(id, convertTime, repeatPlay, path1);
        this.lookUp = new StaticAnimation(path2);
        this.lookDown = new StaticAnimation(path3);
    }

    @Override
    public void onUpdate(EntitydataFighter entity) {
        AnimatorClient animator = entity.getClientAnimator();
        if (animator.mixLayerActivated && animator.getElapsedTime() >= this.totalTime - 0.05f) {
            animator.mixLayer.pause = true;
        }
    }

    @Override
    public Pose getPoseByTime(EntitydataLiving entitydata, float time) {
        float pitch = ((EntityLivingBase)entitydata.getOriginalEntity()).field_70127_C + (((EntityLivingBase)entitydata.getOriginalEntity()).field_70125_A - ((EntityLivingBase)entitydata.getOriginalEntity()).field_70127_C) * ModCore.partialTick;
        StaticAnimation interpolateAnimation = pitch > 0.0f ? this.lookDown : this.lookUp;
        Pose pose1 = this.getPoseByTime(time);
        Pose pose2 = interpolateAnimation.getPoseByTime(entitydata, time);
        Pose interpolatedPose = Pose.interpolatePose(pose1, pose2, Math.abs(pitch) / 90.0f);
        JointTransform chest = interpolatedPose.getTransformByName("Chest");
        JointTransform head = interpolatedPose.getTransformByName("Head");
        float f = 90.0f;
        float ratio = (f - Math.abs(((EntityLivingBase)entitydata.getOriginalEntity()).field_70125_A)) / f;
        float yawOffset = entitydata.getOriginalEntity().func_184218_aH() ? ((EntityLivingBase)entitydata.getOriginalEntity()).field_70177_z : ((EntityLivingBase)entitydata.getOriginalEntity()).field_70761_aq;
        chest.rotation = Quaternion.rotate((float)(-Math.toRadians((((EntityLivingBase)entitydata.getOriginalEntity()).field_70177_z - yawOffset) * ratio)), new Vec3f(0.0f, 1.0f, 0.0f), chest.getRotation());
        head.rotation = Quaternion.rotate((float)(-Math.toRadians((yawOffset - ((EntityLivingBase)entitydata.getOriginalEntity()).field_70177_z) * ratio)), new Vec3f(0.0f, 1.0f, 0.0f), head.getRotation());
        return interpolatedPose;
    }

    private Pose getPoseByTime(float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(time));
        }
        return pose;
    }

    @Override
    public StaticAnimation bind(Armature armature) {
        if (this.animationDataPath != null) {
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.animationDataPath), this, armature);
            this.animationDataPath = null;
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.lookUp.animationDataPath), this.lookUp, armature);
            this.lookUp.animationDataPath = null;
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.lookDown.animationDataPath), this.lookDown, armature);
            this.lookDown.animationDataPath = null;
        }
        return this;
    }
}

