/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types;

import com.epicfight.animation.Animator;
import com.epicfight.animation.JointTransform;
import com.epicfight.animation.Pose;
import com.epicfight.animation.TransformSheet;
import com.epicfight.animation.types.ImmovableAnimation;
import com.epicfight.capabilities.entity.CapabilityEntity;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import com.epicfight.utils.math.Vec4f;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayerMP;

public class CoordMoveAnimation<T extends EntitydataLiving>
extends ImmovableAnimation<T> {
    protected final boolean breakMovement;
    protected final boolean affectYCoord;

    public CoordMoveAnimation(int id, float convertTime, boolean breakMove, boolean affectY, String path) {
        super(id, convertTime, path);
        this.breakMovement = breakMove;
        this.affectYCoord = affectY;
    }

    @Override
    public void onActivate(T entity) {
        float yaw;
        super.onActivate(entity);
        ((EntityLivingBase)((EntitydataLiving)entity).getOriginalEntity()).field_70759_as = yaw = ((EntityLivingBase)((EntitydataLiving)entity).getOriginalEntity()).field_70177_z;
        ((EntityLivingBase)((EntitydataLiving)entity).getOriginalEntity()).field_70761_aq = yaw;
        if (this.breakMovement) {
            ((EntityLivingBase)((EntitydataLiving)entity).getOriginalEntity()).field_70159_w = 0.0;
            ((EntityLivingBase)((EntitydataLiving)entity).getOriginalEntity()).field_70179_y = 0.0;
        }
    }

    @Override
    public void onUpdate(T entity) {
        Object elb = ((EntitydataLiving)entity).getOriginalEntity();
        if (((CapabilityEntity)entity).isRemote() ? !(elb instanceof EntityPlayerSP) : elb instanceof EntityPlayerMP) {
            return;
        }
        if (((EntitydataLiving)entity).isInaction()) {
            Vec3f vec3 = this.getCoordVector(entity);
            elb.func_70091_d(MoverType.SELF, (double)vec3.x, (double)vec3.y, (double)vec3.z);
        }
    }

    @Override
    public void onFinish(T entity, boolean isEnd) {
        super.onFinish(entity, isEnd);
        ((EntitydataLiving)entity).prevPosition.scale(0.0f);
        Object orgEntity = ((EntitydataLiving)entity).getOriginalEntity();
        orgEntity.func_191986_a(((EntityLivingBase)orgEntity).field_70702_br, ((EntityLivingBase)orgEntity).field_70701_bs, ((EntityLivingBase)orgEntity).field_191988_bg);
    }

    @Override
    public Pose getPoseByTime(EntitydataLiving entity, float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            JointTransform jt = ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(time);
            if (jointName.equals("Root")) {
                Vec3f vec = jt.getPosition();
                vec.x = 0.0f;
                vec.y = this.affectYCoord ? 0.0f : vec.y;
                vec.z = 0.0f;
            }
            pose.putJointData(jointName, jt);
        }
        return pose;
    }

    protected Vec3f getCoordVector(T entitydata) {
        Object elb = ((EntitydataLiving)entitydata).getOriginalEntity();
        JointTransform jt = ((TransformSheet)this.jointTransforms.get("Root")).getInterpolatedTransform(((Animator)((EntitydataLiving)entitydata).getAnimator()).getElapsedTime());
        Vec3f vec3 = jt.getPosition();
        Vec4f vec4 = new Vec4f(-vec3.x, vec3.y, -vec3.z, 1.0f);
        Mat4f mat = ((EntitydataLiving)entitydata).getModelMatrix();
        mat.m30 = 0.0f;
        mat.m31 = 0.0f;
        mat.m32 = 0.0f;
        Mat4f.transform(mat, vec4, vec4);
        float dx = vec4.x - ((EntitydataLiving)entitydata).prevPosition.x;
        float dy = this.affectYCoord ? vec4.y - ((EntitydataLiving)entitydata).prevPosition.y : 0.0f;
        float dz = vec4.z - ((EntitydataLiving)entitydata).prevPosition.z;
        if (this.affectYCoord && dy >= 0.0f) {
            ((EntityLivingBase)elb).field_70181_x = Math.min(((EntityLivingBase)elb).field_70181_x + 0.08, 0.0);
        }
        vec3.x = vec4.x;
        vec3.y = vec4.y;
        vec3.z = vec4.z;
        ((EntitydataLiving)entitydata).prevPosition = vec3;
        return new Vec3f(dx, dy, dz);
    }
}

