/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types;

import com.epicfight.animation.AnimationPlayer;
import com.epicfight.animation.JointKeyframe;
import com.epicfight.animation.JointTransform;
import com.epicfight.animation.Pose;
import com.epicfight.animation.TransformSheet;
import com.epicfight.animation.types.LinkAnimation;
import com.epicfight.capabilities.entity.EntitydataLiving;
import java.util.HashMap;
import java.util.Map;

public class DynamicAnimation<T extends EntitydataLiving> {
    protected final Map<String, TransformSheet> jointTransforms = new HashMap<String, TransformSheet>();
    protected final boolean isRepeat;
    protected final float convertTime;
    protected float totalTime;

    public DynamicAnimation() {
        this.totalTime = 0.0f;
        this.isRepeat = false;
        this.convertTime = 0.16f;
    }

    public DynamicAnimation(float convertTime, boolean isRepeat) {
        this(0.0f, convertTime, isRepeat);
    }

    public DynamicAnimation(float totalTime, float convertTime, boolean isRepeat) {
        this.totalTime = totalTime;
        this.isRepeat = isRepeat;
        this.convertTime = convertTime;
    }

    public void addSheet(String jointName, TransformSheet sheet) {
        this.jointTransforms.put(jointName, sheet);
    }

    public Pose getPoseByTime(EntitydataLiving entitydata, float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            pose.putJointData(jointName, this.jointTransforms.get(jointName).getInterpolatedTransform(time));
        }
        return pose;
    }

    public void getLinkAnimation(Pose pose1, float timeModifier, EntitydataLiving entitydata, LinkAnimation dest) {
        float totalTime = Math.max(timeModifier + this.convertTime, 0.0f);
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setNextAnimation(this);
        Map<String, JointTransform> data1 = pose1.getJointTransformData();
        Map<String, JointTransform> data2 = this.getPoseByTime(entitydata, 0.0f).getJointTransformData();
        for (String jointName : data1.keySet()) {
            JointKeyframe[] keyframes = new JointKeyframe[]{new JointKeyframe(0.0f, data1.get(jointName)), new JointKeyframe(totalTime, data2.get(jointName))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.addSheet(jointName, sheet);
        }
    }

    public void putOnPlayer(AnimationPlayer player) {
        player.setPlayAnimation(this);
    }

    public void onActivate(T entitydata) {
    }

    public void onUpdate(T entitydata) {
    }

    public void onFinish(T entitydata, boolean isEnd) {
    }

    public EntitydataLiving.EntityState getState(float time) {
        return EntitydataLiving.EntityState.FREE;
    }

    public Map<String, TransformSheet> getTransfroms() {
        return this.jointTransforms;
    }

    public float getPlaySpeed(EntitydataLiving entitydata) {
        return 1.0f;
    }

    public void setTotalTime(float totalTime) {
        this.totalTime = totalTime;
    }

    public float getTotalTime() {
        return this.totalTime - 1.0E-6f;
    }

    public float getConvertTime() {
        return this.convertTime;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }
}

