/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types;

import com.epicfight.animation.types.OneShotAnimation;
import com.epicfight.capabilities.entity.CapabilityEntity;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.epicfight.client.input.PlayerController;
import com.epicfight.network.PacketManager;
import com.epicfight.network.client.CTSRotatePlayerYaw;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ImmovableAnimation<T extends EntitydataLiving>
extends OneShotAnimation<T> {
    public ImmovableAnimation(int id, float convertTime, String path) {
        super(id, convertTime, false, path);
    }

    @Override
    public void onActivate(T entitydata) {
        super.onActivate(entitydata);
        if (((CapabilityEntity)entitydata).isRemote()) {
            ((EntitydataLiving)entitydata).getClientAnimator().resetMotion();
            ((EntitydataLiving)entitydata).currentMotion = AnimatorClient.LivingMotion.IDLE;
            ((EntitydataLiving)entitydata).getClientAnimator().offMixLayer();
        }
        ((EntitydataLiving)entitydata).cancelUsingItem();
    }

    @Override
    public void onFinish(T entitydata, boolean isEnd) {
        super.onFinish(entitydata, isEnd);
        if (((CapabilityEntity)entitydata).isRemote() && entitydata instanceof EntitydataPlayerSP && isEnd) {
            ((EntitydataPlayerSP)entitydata).changeYaw(0.0f);
            PacketManager.packetHandler.sendToServer((IMessage)new CTSRotatePlayerYaw(0.0f));
            PlayerController.enableMoveKeys();
        }
    }

    @Override
    public EntitydataLiving.EntityState getState(float time) {
        return EntitydataLiving.EntityState.INACTION;
    }
}

