/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types;

import com.epicfight.animation.types.DynamicAnimation;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.collada.AnimationDataExtractor;
import com.epicfight.gamedata.Animations;
import com.epicfight.model.Armature;
import net.minecraft.util.ResourceLocation;

public class StaticAnimation<T extends EntitydataLiving>
extends DynamicAnimation<T> {
    protected String animationDataPath;
    protected final int animationId;

    public StaticAnimation() {
        this.animationId = -1;
    }

    public StaticAnimation(int id, float convertTime, boolean isRepeat, String path) {
        super(convertTime, isRepeat);
        if (Animations.animationTable.keySet().contains(id)) {
            System.err.println("[ModError] : Duplicated Animation Key " + id);
        }
        this.animationDataPath = "models/animations/" + path;
        this.totalTime = 0.0f;
        this.animationId = id;
        Animations.animationTable.put(id, this);
    }

    public StaticAnimation(String path) {
        this();
        this.animationDataPath = "models/animations/" + path;
    }

    public StaticAnimation(float convertTime, boolean repeatPlay, String path) {
        super(convertTime, repeatPlay);
        this.animationId = -1;
        this.animationDataPath = "models/animations/" + path;
    }

    public StaticAnimation(int id, boolean repeatPlay, String path) {
        this(id, 0.16f, repeatPlay, path);
    }

    public StaticAnimation bind(Armature armature) {
        if (this.animationDataPath != null) {
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.animationDataPath), this, armature);
            this.animationDataPath = null;
        }
        return this;
    }

    public int getId() {
        return this.animationId;
    }
}

