/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types;

import com.epicfight.animation.Animator;
import com.epicfight.animation.JointKeyframe;
import com.epicfight.animation.JointTransform;
import com.epicfight.animation.Pose;
import com.epicfight.animation.TransformSheet;
import com.epicfight.animation.types.LinkAnimation;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.entity.EntitydataLiving;
import java.util.Map;

public class SuccessiveAnimation
extends StaticAnimation<EntitydataLiving> {
    private final StaticAnimation<EntitydataLiving> firstAnimation;
    private final StaticAnimation<EntitydataLiving> nextAnimation;
    private final float secondConvertTime;

    public SuccessiveAnimation(int id, float convertTime, float secondConvertTime, StaticAnimation firstAnimation, StaticAnimation nextAnimation) {
        super(id, convertTime, false, null);
        this.secondConvertTime = secondConvertTime;
        this.firstAnimation = firstAnimation;
        this.nextAnimation = nextAnimation;
    }

    @Override
    public void onActivate(EntitydataLiving entitydata) {
        this.firstAnimation.onActivate(entitydata);
    }

    @Override
    public void onUpdate(EntitydataLiving entitydata) {
        this.firstAnimation.onUpdate(entitydata);
    }

    @Override
    public void onFinish(EntitydataLiving entitydata, boolean isEnd) {
        this.firstAnimation.onFinish(entitydata, isEnd);
        if (isEnd) {
            ((Animator)entitydata.getAnimator()).vacateCurrentPlay();
            ((Animator)entitydata.getAnimator()).playAnimation(this.nextAnimation, this.secondConvertTime);
        }
    }

    @Override
    public Pose getPoseByTime(EntitydataLiving entitydata, float time) {
        Pose pose = new Pose();
        for (String jointName : this.firstAnimation.jointTransforms.keySet()) {
            pose.putJointData(jointName, ((TransformSheet)this.firstAnimation.jointTransforms.get(jointName)).getInterpolatedTransform(time));
        }
        return pose;
    }

    @Override
    public void getLinkAnimation(Pose pose1, float timeModifier, EntitydataLiving entitydata, LinkAnimation dest) {
        dest.getTransfroms().clear();
        dest.setTotalTime(timeModifier + this.convertTime);
        dest.setNextAnimation(this.firstAnimation);
        Map<String, JointTransform> data1 = pose1.getJointTransformData();
        Map<String, JointTransform> data2 = this.getPoseByTime(entitydata, 0.0f).getJointTransformData();
        for (String jointName : data1.keySet()) {
            JointKeyframe[] keyframes = new JointKeyframe[]{new JointKeyframe(0.0f, data1.get(jointName)), new JointKeyframe(timeModifier + this.convertTime, data2.get(jointName))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.addSheet(jointName, sheet);
        }
    }
}

