/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types.attack;

import com.epicfight.animation.Animator;
import com.epicfight.animation.Pose;
import com.epicfight.animation.types.LinkAnimation;
import com.epicfight.animation.types.attack.AttackAnimation;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.capabilities.entity.player.EntitydataPlayerMP;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.epicfight.client.input.PlayerController;
import com.epicfight.physics.Collider;
import javax.annotation.Nullable;

public class AAAnimation
extends AttackAnimation {
    protected final float basisSpeed;

    public AAAnimation(int id, float convertTime, float antic, float contact, float recovery, float basisSpeed, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, antic, antic, contact, recovery, basisSpeed, collider, index, path);
    }

    public AAAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, float basisSpeed, @Nullable Collider collider, String index, String path) {
        super(id, convertTime, antic, preDelay, contact, recovery, false, collider, index, path);
        this.basisSpeed = basisSpeed;
    }

    @Override
    public void onUpdate(EntitydataFighter entitydata) {
        super.onUpdate(entitydata);
        float elapsedTime = ((Animator)entitydata.getAnimator()).getElapsedTime();
        if (elapsedTime > this.antic && (elapsedTime < this.contact || entitydata.attackToggle)) {
            if (entitydata instanceof EntitydataPlayerMP) {
                ((EntitydataPlayerMP)entitydata).gatherSpecialAttackEnergy();
            }
        } else if (elapsedTime > this.recovery && entitydata.isRemote() && entitydata instanceof EntitydataPlayerSP) {
            PlayerController.enableMoveKeys();
            AnimatorClient animator = entitydata.getClientAnimator();
            entitydata.updateMotion();
            if (!animator.compareMotion(entitydata.currentMotion)) {
                animator.playLoopMotion();
            }
        }
    }

    @Override
    public float getPlaySpeed(EntitydataLiving entitydata) {
        if (entitydata instanceof EntitydataPlayer) {
            EntitydataPlayer playerdata = (EntitydataPlayer)entitydata;
            float elapsedTime = ((Animator)entitydata.getAnimator()).getElapsedTime();
            if (elapsedTime > this.preDelay && elapsedTime < this.contact) {
                return 1.0f;
            }
            return playerdata.getAttackSpeed() / this.basisSpeed;
        }
        return 1.0f;
    }

    @Override
    public void getLinkAnimation(Pose pose1, float timeModifier, EntitydataLiving entitydata, LinkAnimation dest) {
        float extTime = Math.max(this.convertTime + timeModifier, 0.0f);
        if (entitydata instanceof EntitydataPlayer) {
            EntitydataPlayer playerdata = (EntitydataPlayer)entitydata;
            extTime *= this.basisSpeed / playerdata.getAttackSpeed();
        }
        extTime = Math.max(extTime - this.convertTime, 0.0f);
        super.getLinkAnimation(pose1, extTime, entitydata, dest);
    }
}

