/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types.attack;

import com.epicfight.animation.Animator;
import com.epicfight.animation.types.CoordMoveAnimation;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.entity.EntitydataMob;
import com.epicfight.capabilities.entity.mob.EntitydataBipedMob;
import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.physics.Collider;
import com.epicfight.utils.game.AttackResult;
import com.epicfight.utils.game.IExtendedDamageSource;
import com.epicfight.utils.math.Mat4f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;

public class AttackAnimation
extends CoordMoveAnimation<EntitydataFighter> {
    protected final float antic;
    protected final float preDelay;
    protected final float contact;
    protected final float recovery;
    protected Collider collider;
    protected final int jointIndexer;

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, @Nullable Collider collider, String index, String path) {
        super(id, convertTime, true, affectY, path);
        this.antic = antic;
        this.preDelay = preDelay;
        this.contact = contact;
        this.recovery = recovery;
        this.collider = collider;
        int coded = 0;
        for (int i = 0; i < index.length(); ++i) {
            int value = index.charAt(i) - 48;
            coded |= value;
            coded <<= 5;
        }
        this.jointIndexer = coded;
    }

    @Override
    public void onActivate(EntitydataFighter entitydata) {
        super.onActivate(entitydata);
        entitydata.attackToggle = true;
        entitydata.lastDealtDamageAmount = 0.0f;
    }

    @Override
    public void onUpdate(EntitydataFighter entitydata) {
        block10: {
            float elapsedTime;
            block9: {
                super.onUpdate(entitydata);
                elapsedTime = ((Animator)entitydata.getAnimator()).getElapsedTime();
                if (!(elapsedTime <= this.antic)) break block9;
                if (entitydata.isRemote() || !(entitydata instanceof EntitydataMob)) break block10;
                EntityCreature entity = (EntityCreature)entitydata.getOriginalEntity();
                entity.func_70661_as().func_75499_g();
                if (entity.func_70638_az() != null) {
                    entitydata.rotateTo((Entity)entity.func_70638_az(), 60.0f, false);
                }
                break block10;
            }
            if (elapsedTime > this.preDelay && (elapsedTime <= this.contact || entitydata.attackToggle)) {
                if (entitydata.attackToggle) {
                    Object executer = entitydata.getOriginalEntity();
                    ((Entity)executer).field_70170_p.func_184148_a(null, ((Entity)executer).field_70165_t, ((Entity)executer).field_70163_u, ((Entity)executer).field_70161_v, this.getAttackSound(entitydata), executer.func_184176_by(), 1.0f, 1.0f);
                    entitydata.attackToggle = false;
                }
                if (!entitydata.isRemote()) {
                    Collider collider = this.getCollider(entitydata);
                    Object entity = entitydata.getOriginalEntity();
                    entitydata.getEntityModel().getArmature().initializeTransform();
                    Mat4f jointTransform = entitydata.getServerAnimator().getColliderTransformMatrix(this.jointIndexer);
                    collider.transform(Mat4f.mul(entitydata.getModelMatrix(), jointTransform, null));
                    List list = ((Entity)entity).field_70170_p.func_72839_b(entity, collider.getHitboxAABB());
                    collider.extractHitEntities(list);
                    if (list.size() > 0) {
                        AttackResult attackResult = new AttackResult((Entity)entity, list);
                        int i = 0;
                        while (entitydata.currentlyAttackedEntity.size() < this.getHitEnemies(entitydata)) {
                            Entity e = attackResult.getEntity();
                            if (!entitydata.currentlyAttackedEntity.contains(e) && !entitydata.isTeam(e) && e instanceof EntityLivingBase && e.field_70170_p.func_147447_a(new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v), new Vec3d(((Entity)entity).field_70165_t, ((Entity)entity).field_70163_u + (double)(((Entity)entity).field_70131_O * 0.5f), ((Entity)entity).field_70161_v), false, true, false) == null) {
                                if (e.func_70097_a((DamageSource)this.getDamageSourceExt(entitydata), this.getDamageAmount(entitydata, e))) {
                                    entitydata.hitEntity(e);
                                    e.field_70172_ad = 0;
                                    e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, entitydata.getWeaponHitSound(), e.func_184176_by(), 1.0f, 1.0f);
                                    if (i == 0 && entitydata instanceof EntitydataPlayer) {
                                        entitydata.getOriginalEntity().func_184614_ca().func_77961_a((EntityLivingBase)e, (EntityPlayer)((EntitydataPlayer)entitydata).getOriginalEntity());
                                    }
                                    ++i;
                                }
                                entitydata.currentlyAttackedEntity.add(e);
                            }
                            if (attackResult.next()) continue;
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onFinish(EntitydataFighter entitydata, boolean isEnd) {
        EntityCreature entity;
        super.onFinish(entitydata, isEnd);
        entitydata.currentlyAttackedEntity.clear();
        if (entitydata instanceof EntitydataBipedMob && entitydata.isRemote() && (entity = (EntityCreature)entitydata.getOriginalEntity()).func_70638_az() != null && !entity.func_70638_az().func_70089_S()) {
            entity.func_70624_b((EntityLivingBase)null);
        }
    }

    @Override
    public EntitydataLiving.EntityState getState(float time) {
        if (this.antic >= time) {
            return EntitydataLiving.EntityState.ANTIC;
        }
        if (this.antic < time && this.preDelay >= time) {
            return EntitydataLiving.EntityState.INACTION;
        }
        if (this.preDelay < time && this.contact >= time) {
            return EntitydataLiving.EntityState.CONTACT;
        }
        if (this.recovery > time) {
            return EntitydataLiving.EntityState.RECOVERY;
        }
        return EntitydataLiving.EntityState.FREE;
    }

    public Collider getCollider(EntitydataFighter entitydata) {
        return this.collider != null ? this.collider : entitydata.getColliderMatching();
    }

    public int getHitEnemies(EntitydataFighter entitydata) {
        return entitydata.getHitEnemies();
    }

    public float getDamageAmount(EntitydataFighter entitydata, Entity target) {
        return entitydata.getDamageToEntity(target);
    }

    public SoundEvent getAttackSound(EntitydataFighter entitydata) {
        return entitydata.getAttackSound();
    }

    public IExtendedDamageSource getDamageSourceExt(EntitydataFighter entitydata) {
        return entitydata.getDamageSource(IExtendedDamageSource.StunType.SHORT);
    }

    public int getIndexer() {
        return this.jointIndexer;
    }

    @Deprecated
    public void changeCollider(Collider newCollider) {
        this.collider = newCollider;
    }
}

